package com.newrelic.agent.profile.method;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.InstrumentedMethod;
import com.newrelic.agent.util.StringMap;
import com.newrelic.agent.util.Strings;

public abstract class MethodInfo {

    public abstract List<Map<String, Object>> getJsonMethodMaps(StringMap stringMap);
    
    @Deprecated
    public final List<Map<String, Object>> getJsonMethodMaps() {
        return getJsonMethodMaps(Strings.getPassthroughStringMap());
    }

    private static void addOneMethodInstrumentedInfo(Map<String, Object> toAdd, InstrumentedMethod instrumentedMethod) {
        if (instrumentedMethod != null) {
            Map<String, Object> inst = Maps.newHashMap();
            inst.put("dispatcher", instrumentedMethod.dispatcher());
            addInstrumentationInfo(inst, instrumentedMethod);

            toAdd.put("traced_instrumentation", inst);
        }
    }

    private static void addInstrumentationInfo(Map<String, Object> inst, InstrumentedMethod instrumentedMethod) {
        addInstrumentationInfo(inst, instrumentedMethod, Strings.getPassthroughStringMap());
    }

    private static void addInstrumentationInfo(Map<String, Object> inst, InstrumentedMethod instrumentedMethod, StringMap stringMap) {
        InstrumentationType[] inputTypes = instrumentedMethod.instrumentationTypes();
        String[] inputNames = instrumentedMethod.instrumentationNames();

        if (inputTypes != null && inputNames != null && inputTypes.length > 0) {
            if (inputTypes.length == inputNames.length) {
                Map<String, List<Object>> instrumentedTypes = Maps.newHashMap();

                for (int i = 0; i < inputTypes.length; i++) {
                    if (isTimedInstrumentation(inputTypes[i])) {
                        List<Object> names = instrumentedTypes.get(inputTypes[i].toString());
                        if (names == null) {
                            names = Lists.newArrayList();
                            names.add(stringMap.addString(inputNames[i]));
                            instrumentedTypes.put(inputTypes[i].toString(), names);
                        } else {
                            names.add(stringMap.addString(inputNames[i]));
                        }
                    }
                }

                if (instrumentedTypes.size() > 0) {
                    inst.put("types", instrumentedTypes);
                }
            }
        }
    }
    
    static Map<String, Object> getMethodMap(StringMap stringMap, List<String> arguments, InstrumentedMethod annotation) {
        Map<String, Object> map = Maps.newHashMap();
        addOneMethodArgs(stringMap, map, arguments);
        addOneMethodInstrumentedInfo(map, annotation);
        
        return map;
    }

    private static boolean isTimedInstrumentation(InstrumentationType type) {
        return (type != InstrumentationType.WeaveInstrumentation);
    }
    
    private static void addOneMethodArgs(StringMap stringMap, Map<String, Object> toAdd, List<String> arguments) {
        List<Object> tokens = Lists.newArrayListWithCapacity(arguments.size());
        for (String arg : arguments) {
            tokens.add(stringMap.addString(arg));
        }
        toAdd.put("args", tokens);
    }

}
