package com.newrelic.agent.logging;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.PatternLayoutEncoderBase;

class CustomPatternLogbackEncoder extends PatternLayoutEncoderBase<ILoggingEvent> {

    /**
     * 
     * Creates this CustomPatternLogbackEncoder.
     * 
     * @param pPattern The pattern to use.
     */
    public CustomPatternLogbackEncoder(final String pPattern) {
        super();
        setPattern(pPattern);
    }

    /**
     * Starts the custom pattern logback encoder.
     */
    @Override
    public void start() {
        PatternLayout patternLayout = new CustomPatternLogbackLayout(getPattern());
        patternLayout.setContext(context);
        patternLayout.setOutputPatternAsHeader(outputPatternAsHeader);
        patternLayout.start();
        this.layout = patternLayout;
        super.start();
    }

}
