package com.newrelic.agent.jmx.values;

import java.util.ArrayList;
import java.util.List;

import com.newrelic.agent.MetricNames;
import com.newrelic.agent.jmx.JmxType;
import com.newrelic.agent.jmx.metrics.BaseJmxValue;
import com.newrelic.agent.jmx.metrics.JmxAction;
import com.newrelic.agent.jmx.metrics.JmxFrameworkValues;
import com.newrelic.agent.jmx.metrics.JmxMetric;
import com.newrelic.agent.jmx.metrics.ServerJmxMetricGenerator;

public class Jboss56JmxValues extends JmxFrameworkValues {

    private static String PREFIX = "jboss.web";

    private static final int METRIC_COUNT = 2;
    private static final List<BaseJmxValue> METRICS = new ArrayList<BaseJmxValue>(METRIC_COUNT);

    // SESSION METRICS - lower case version
    private static final JmxMetric ACTIVE_SESSIONS = JmxMetric.create(
            new String[] { "activeSessions", "ActiveSessions" }, MetricNames.JMX_SESSION_ACTIVE,
            JmxAction.USE_FIRST_RECORDED_ATT, JmxType.SIMPLE);
    private static final JmxMetric SESSION_ALIVE_TIME = JmxMetric.create(new String[] { "sessionAverageAliveTime",
            "SessionAverageAliveTime" }, MetricNames.JMX_SESSION_ALIVE_TIME, JmxAction.USE_FIRST_RECORDED_ATT,
            JmxType.SIMPLE);

    private static final JmxMetric EXPIRED_SESSIONS = JmxMetric.create(new String[] { "expiredSessions",
            "ExpiredSessions" }, MetricNames.JMX_SESSION_EXPIRED, JmxAction.USE_FIRST_RECORDED_ATT,
            JmxType.MONOTONICALLY_INCREASING);
    private static final JmxMetric REJECTED_SESSIONS = JmxMetric.create(new String[] { "rejectedSessions",
            "RejectedSessions" }, MetricNames.JMX_SESSION_REJECTED, JmxAction.USE_FIRST_RECORDED_ATT,
            JmxType.MONOTONICALLY_INCREASING);

    // THREAD POOL METRICS
    private static final JmxMetric CURRENT_MAX_COUNT = ServerJmxMetricGenerator.MAX_THREAD_POOL_COUNT.createMetric("maxThreads");
    private static final JmxMetric CURRENT_ACTIVE_COUNT = ServerJmxMetricGenerator.ACTIVE_THREAD_POOL_COUNT.createMetric("currentThreadsBusy");
    private static final JmxMetric CURRENT_IDLE_COUNT = JmxMetric.create(new String[] { "currentThreadCount",
            "currentThreadsBusy" }, MetricNames.JMX_THREAD_POOL_IDLE, JmxAction.SUBTRACT_ALL_FROM_FIRST, JmxType.SIMPLE);

    static {

        /* Provides thread pool information. */
        METRICS.add(new BaseJmxValue("jboss.web:type=ThreadPool,name=*", MetricNames.JMX_THREAD_POOL + "{name}/",
                new JmxMetric[] { CURRENT_ACTIVE_COUNT, CURRENT_IDLE_COUNT, CURRENT_MAX_COUNT }));

        /* Provides session information. */
        METRICS.add(new BaseJmxValue("jboss.web:type=Manager,path=*,host=*", MetricNames.JMX_SESSION + "{path}/",
                new JmxMetric[] { ACTIVE_SESSIONS, EXPIRED_SESSIONS, REJECTED_SESSIONS, SESSION_ALIVE_TIME }));

    }

    public Jboss56JmxValues() {
        super();
    }

    @Override
    public List<BaseJmxValue> getFrameworkMetrics() {
        return METRICS;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

}
