package com.newrelic.agent.jmx.values;

import java.util.ArrayList;
import java.util.List;

import com.newrelic.agent.MetricNames;
import com.newrelic.agent.jmx.metrics.BaseJmxValue;
import com.newrelic.agent.jmx.metrics.JmxFrameworkValues;
import com.newrelic.agent.jmx.metrics.JmxMetric;
import com.newrelic.agent.jmx.metrics.ServerJmxMetricGenerator;

public class Glassfish2JmxValues extends JmxFrameworkValues {

    private static final int METRIC_COUNT = 3;

    private static final List<BaseJmxValue> METRICS = new ArrayList<BaseJmxValue>(METRIC_COUNT);

    private static String PREFIX = "com.sun";

    static {
        /*
         * Provides thread pool information.
         */
        METRICS.add(new BaseJmxValue(
                "com.sun.appserv:name=*,type=thread-pool,category=monitor,server=*",
                MetricNames.JMX_THREAD_POOL + "{name}/",
                new JmxMetric[] {
                        ServerJmxMetricGenerator.ACTIVE_THREAD_POOL_COUNT.createMetric("numberofbusythreads-count"),
                        ServerJmxMetricGenerator.IDLE_THREAD_POOL_COUNT.createMetric("numberofavailablethreads-count") }));
        /*
         * Provides session information.
         */
        METRICS.add(new BaseJmxValue("com.sun.appserv:type=Manager,path=*,host=server", MetricNames.JMX_SESSION
                + "{path}/", new JmxMetric[] {
                ServerJmxMetricGenerator.SESSION_ACTIVE_COUNT.createMetric("activeSessions"),
                ServerJmxMetricGenerator.SESSION_EXPIRED_COUNT.createMetric("expiredSessions"),
                ServerJmxMetricGenerator.SESSION_REJECTED_COUNT.createMetric("rejectedSessions"),
                ServerJmxMetricGenerator.SESSION_AVG_ALIVE_TIME.createMetric("sessionAverageAliveTimeSeconds") }));

        /*
         * Provides transaction information.
         */
        METRICS.add(new BaseJmxValue("com.sun.appserv:type=transaction-service,category=monitor,server=*",
                MetricNames.JMX_TRANSACITON, new JmxMetric[] {
                        ServerJmxMetricGenerator.TRANS_ACTIVE_COUNT.createMetric("activecount-count"),
                        ServerJmxMetricGenerator.TRANS_COMMITED_COUNT.createMetric("committedcount-count"),
                        ServerJmxMetricGenerator.TRANS_ROLLED_BACK_COUNT.createMetric("rolledbackcount-count") }));

    }

    public Glassfish2JmxValues() {
        super();
    }

    @Override
    public List<BaseJmxValue> getFrameworkMetrics() {
        return METRICS;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

}
