package com.newrelic.agent.jmx;

import java.util.Map;

import javax.management.Attribute;
import javax.management.ObjectInstance;

import com.newrelic.agent.stats.StatsEngine;

/**
 * A custom jmx attribute processor.
 * 
 * @author sdaubin
 * 
 */
public interface JmxAttributeProcessor {

    /**
     * Returns true if this processor recorded stats for the given jmx attribute.
     * 
     * @param statsEngine
     * @param instance
     * @param attribute
     * @param metricName
     * @return
     */
    boolean process(StatsEngine statsEngine, ObjectInstance instance, Attribute attribute, String metricName,
            Map<String, Float> values);

}
