package com.newrelic.agent.instrumentation.pointcuts.container.tomcat;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.jmx.values.TomcatJmxValues;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;

/**
 * Point cut used to detect Apache Tomcat and give the Tomcat JMX metrics to the JMX Service.
 * 
 * @since Mar 6, 2013
 * 
 */
@PointCut
public class TomcatStartUpPointCut extends com.newrelic.agent.instrumentation.PointCut implements
        EntryInvocationHandler {

    static final String TOMCAT_INSTRUMENTATION_GROUP_NAME = "tomcat";
    private final AtomicBoolean addedJmx = new AtomicBoolean(false);

    public TomcatStartUpPointCut(PointCutClassTransformer classTransformer) {
        super(
                new PointCutConfiguration(TomcatStartUpPointCut.class.getName(), TOMCAT_INSTRUMENTATION_GROUP_NAME,
                        true), createClassMatcher(), OrMethodMatcher.getMethodMatcher(createExactMethodMatcher("start",
                        "()V"), createExactMethodMatcher("getServer", "()Lorg/apache/catalina/Server;")));
    }

    private static ClassMatcher createClassMatcher() {
        return new OrClassMatcher(new ExactClassMatcher("org/apache/catalina/startup/HostConfig"),
                new ExactClassMatcher("org/apache/catalina/startup/Embedded"), new ExactClassMatcher(
                        "org/apache/catalina/startup/Tomcat"));
    }

    @Override
    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (System.getProperty("com.sun.aas.installRoot") == null) {
            if (!addedJmx.getAndSet(true)) {
                ServiceFactory.getJmxService().addJmxFrameworkValues(new TomcatJmxValues());
                if (Agent.LOG.isFinerEnabled()) {
                    Agent.LOG.log(Level.FINER, "Added JMX for Tomcat");
                }
            }
        }
    }

    @Override
    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

}
