package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import java.util.List;

import com.newrelic.agent.instrumentation.pointcuts.InterfaceMixin;

/**
 * Jetty uses a MultiException which contains multiple throwables.  The MultiException itself isn't all that meaningful - the
 * good stuff is in its contained throwables.  This interface exposes that list of throwables so we can report stack traces for those.
 * @author sdaubin
 *
 */
@InterfaceMixin(originalClassName = "org/eclipse/jetty/util/MultiException")
public interface MultiException {
    List<Throwable> getThrowables();
}
