package com.newrelic.agent.instrumentation.pointcuts.container.jetty;

import java.util.logging.Level;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.jmx.values.JettyJmxMetrics;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;

@PointCut
public class JettyStartUpPointCut extends com.newrelic.agent.instrumentation.PointCut implements EntryInvocationHandler {

    private boolean addedJmx = false;

    public JettyStartUpPointCut(PointCutClassTransformer classTransformer) {
        super(new PointCutConfiguration(JettyStartUpPointCut.class.getName(), null, true), createClassMatcher(),
                createExactMethodMatcher("start",
                        "(Ljava/util/List;)V",
                        "(Lorg/eclipse/jetty/start/StartArgs;)V"));
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher("org/eclipse/jetty/start/Main");
    }

    @Override
    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (!addedJmx) {
            ServiceFactory.getJmxService().addJmxFrameworkValues(new JettyJmxMetrics());
            addedJmx = true;
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Added JMX for Jetty");
            }
        }
    }

    @Override
    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

}
