package com.newrelic.agent.instrumentation.pointcuts.container.jboss;

import java.util.logging.Level;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.jmx.values.Jboss7UpJmxValues;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;

/**
 * Detects jboss. This has been checked on 7.0 AS, 7.1 AS, and 6.0 EAP.
 * 
 */
@PointCut
public class Jboss7StartupPointCut extends com.newrelic.agent.instrumentation.PointCut implements
        EntryInvocationHandler {

    public static final String JBOSS_INSTRUMENTATION_GROUP_NAME = "jboss_instrumentation";

    private boolean addedJmx = false;

    public Jboss7StartupPointCut(PointCutClassTransformer classTransformer) {
        super(new PointCutConfiguration(Jboss7StartupPointCut.class.getName(), JBOSS_INSTRUMENTATION_GROUP_NAME, true),
                createClassMatcher(), new ExactMethodMatcher("installMBeanServer", "()V"));
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher("org/jboss/modules/ModuleLoader");
    }

    @Override
    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (!addedJmx) {
            ServiceFactory.getJmxService().addJmxFrameworkValues(new Jboss7UpJmxValues());
            addedJmx = true;
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Added JMX for Jboss/Wildfly");
            }
        }
    }

    @Override
    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

}
