package com.newrelic.agent.instrumentation.methodmatchers;

import java.util.Set;

import org.objectweb.asm.commons.Method;

public class AccessMethodMatcher implements MethodMatcher {

    private final int accessFlags;

    public AccessMethodMatcher(int accessFlags) {
        super();
        this.accessFlags = accessFlags;
    }

    @Override
    public boolean matches(int access, String name, String desc, Set<String> annotations) {
        return access == MethodMatcher.UNSPECIFIED_ACCESS || (access & accessFlags) == accessFlags;
    }

    @Override
    public Method[] getExactMethods() {
        return null;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + accessFlags;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AccessMethodMatcher other = (AccessMethodMatcher) obj;
        return accessFlags == other.accessFlags;
    }

}
