package com.newrelic.agent.install;

import com.newrelic.agent.install.AppServerIdentifier.AppServerType;

public class SelfInstallerFactory {

    /**
     * Returns a new SelfInstaller for the specified app server type.
     * 
     * SRH - Added support for Glassfish
     * 
     * @throws Exception if the type is unrecognized.
     */
    public static SelfInstaller getSelfInstaller(AppServerType type) throws Exception {
        if (type == AppServerType.TOMCAT) {
            return new TomcatSelfInstaller();
        } else if (type == AppServerType.JETTY) {
            return new JettySelfInstaller();
        } else if (type == AppServerType.JBOSS) {
            return new JBossSelfInstaller();
        } else if (type == AppServerType.JBOSS7) {
            return new JBoss7SelfInstaller();
        } else if (type == AppServerType.GLASSFISH) {
            return new GlassfishSelfInstaller();
        }

        throw new Exception("Unknown app server type");
    }

}
