package com.newrelic.agent.config;

import java.util.Map;

public class TransactionEventsConfig extends BaseConfig {

    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.transaction_events.";
    public static final String MAX_SAMPLES_STORED = "max_samples_stored";

    private static final String COLLECT_ANALYTICS_EVENTS = "collect_analytics_events";
    private static final String ENABLED = "enabled";
    private static final String TARGET_SAMPLES_STORED = "target_samples_stored";

    public static final boolean DEFAULT_ENABLED = true;
    public static final int DEFAULT_MAX_SAMPLES_STORED = 2000;
    public static final int DEFAULT_TARGET_SAMPLES_STORED = 10;

    private final boolean enabled;
    private final int maxSamplesStored;
    private final int targetSamplesStored;

    public TransactionEventsConfig(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        maxSamplesStored = getProperty(MAX_SAMPLES_STORED, DEFAULT_MAX_SAMPLES_STORED);
        enabled = maxSamplesStored > 0 & initEnabled();
        targetSamplesStored = getProperty(TARGET_SAMPLES_STORED, DEFAULT_TARGET_SAMPLES_STORED);
    }

    private boolean initEnabled() {
        // "collect_analytics_events" is the property which comes down from the server.
        // This gets mapped to transaction_events.collect_analytics_events in AgentConfigFactory.mergeServerData()
        return getProperty(ENABLED, DEFAULT_ENABLED) &&
               getProperty(COLLECT_ANALYTICS_EVENTS, DEFAULT_ENABLED);
    }

    public boolean isEnabled() {
        return enabled;
    }

    public int getMaxSamplesStored() {
        return maxSamplesStored;
    }

    public int getTargetSamplesStored() {
        return targetSamplesStored;
    }
}
