package com.newrelic.agent.config;

import com.newrelic.agent.Agent;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StripExceptionConfigImpl extends BaseConfig implements StripExceptionConfig {

    public static final String ENABLED = "enabled";
    public static final String WHITELIST = "whitelist";
    public static final String SYSTEM_PROPERTY_ROOT =
            "newrelic.config." + AgentConfigImpl.STRIP_EXCEPTION_MESSAGES + ".";

    private boolean isEnabled;
    private final Set<String> whitelist;

    private StripExceptionConfigImpl(Map<String, Object> props, boolean highSecurity) {
        super(props, SYSTEM_PROPERTY_ROOT);
        isEnabled = getProperty(ENABLED, highSecurity);
        whitelist = Collections.unmodifiableSet(new HashSet<String>(getUniqueStrings(WHITELIST)));
    }

    @Override
    public boolean isEnabled() {
        return isEnabled;
    }

    @Override
    public Set<String> getWhitelist() {
        return whitelist;
    }

    static StripExceptionConfig createStripExceptionConfig(Map<String, Object> settings, boolean highSecurity) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new StripExceptionConfigImpl(settings, highSecurity);
    }

    public void setEnabled(boolean enabled) {
        isEnabled = enabled;
        Agent.LOG.info(MessageFormat.format("Exception messages will{0} be stripped before sending to New Relic",
                    isEnabled() ? "" : " not"));
    }

}
