package com.newrelic.agent.config;

import java.util.Set;

public interface StripExceptionConfig {

    /**
     * @return true if exception message stripping is enabled.
     */
    boolean isEnabled();

    /**
     * This exists because LASP could need to change the stripped exception config on the fly
     * @param enabled
     */
    void setEnabled(boolean enabled);

    /**
     * Get the set of exception classes that are whitelisted. The returned strings are the value of Class.getName()
     * for each class. For example:
     *
     * java.lang.NullPointerException
     * java.lang.IllegalStateException
     *
     * @return the set of exception classes that are whitelisted
     */
    Set<String> getWhitelist();

}
