package com.newrelic.agent.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

class JmxConfigImpl extends BaseConfig implements JmxConfig {

    public static final String ENABLED = "enabled";
    public static final String CREATE_MBEAN_SERVER = "create_mbean_server";
    public static final String DISABLED_JMX_FRAMEWORKS = "disabled_jmx_frameworks";
    public static final Boolean DEFAULT_ENABLED = Boolean.TRUE;
    public static final Boolean DEFAULT_CREATE_MBEAN_SERVER = Boolean.TRUE;
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.jmx.";

    private final boolean isEnabled;
    private final boolean isCreateMbeanServer;
    private final Collection<String> disabledJmxFrameworks;

    public JmxConfigImpl(Map<String, Object> pProps) {
        super(pProps, SYSTEM_PROPERTY_ROOT);
        isEnabled = getProperty(ENABLED, DEFAULT_ENABLED).booleanValue();
        isCreateMbeanServer = getProperty(CREATE_MBEAN_SERVER, DEFAULT_CREATE_MBEAN_SERVER).booleanValue();
        disabledJmxFrameworks = getUniqueStrings(DISABLED_JMX_FRAMEWORKS, ",");
    }

    static JmxConfigImpl createJmxConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new JmxConfigImpl(settings);
    }

    @Override
    public boolean isEnabled() {
        return isEnabled;
    }

    @Override
    public boolean isCreateMbeanServer() {
        return isCreateMbeanServer;
    }

    @Override
    public Collection<String> getDisabledJmxFrameworks() {
        return disabledJmxFrameworks;
    }

}
