package com.newrelic.agent.config;

import java.util.Collection;

public interface JmxConfig {

    /**
     * True is the jmx service is enabled, else false.
     * 
     * @return <code>true</code> if the jmx service is enabled.
     * 
     */
    boolean isEnabled();

    /**
     * True means an mbean server should be created if needed.
     * 
     * @return <code>true</code> if mbean server should be created as needed.
     */
    boolean isCreateMbeanServer();

    /**
     * These strings should match the prefix found in the Jmx Framework. Any matching strings should be disabled.
     * 
     * @return Strings which match Jmx Framework prefixes that should be disabled.
     */
    Collection<String> getDisabledJmxFrameworks();

}
