package com.newrelic.agent.config;

import com.newrelic.agent.heap.ClassHistogramHelper;

import java.util.Map;

public class ClassHistogramConfigImpl extends BaseConfig implements ClassHistogramConfig {

    public static final String PROPERTY_NAME = "class_histogram";
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config." + PROPERTY_NAME + ".";
    public static final String ENABLED = "enabled";
    public static final boolean DEFAULT_ENABLED = false;
    public static final String CLASSES_PER_HISTOGRAM = "classes_per_histogram";
    public static final int DEFAULT_CLASSES_PER_HISTOGRAM = 49;
    public static final int CLASSES_PER_HISTOGRAM_LIMIT = 500;
    public static final String JAVA_HOME = System.getenv("JAVA_HOME");
    public static final String JMAP_PATH = "jmap_path";
    public static final String DEFAULT_JMAP_PATH = JAVA_HOME + (ClassHistogramHelper.isWindows() ? "\\bin\\" : "/bin/");

    private final boolean enabled;
    private final int numClassesPerHistogram;
    private final String jmapPath;

    public ClassHistogramConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        enabled = getProperty(ENABLED, DEFAULT_ENABLED);

        int cph = getProperty(CLASSES_PER_HISTOGRAM, DEFAULT_CLASSES_PER_HISTOGRAM);
        if (cph < 1) {
            numClassesPerHistogram = DEFAULT_CLASSES_PER_HISTOGRAM;
        } else if (cph > CLASSES_PER_HISTOGRAM_LIMIT) {
            numClassesPerHistogram = CLASSES_PER_HISTOGRAM_LIMIT;
        } else {
            numClassesPerHistogram = cph;
        }

        String rawPath = getProperty(JMAP_PATH, DEFAULT_JMAP_PATH);
        if (ClassHistogramHelper.isWindows()) {
            // if this is in windows we want to rid the path of any quotations and add them back around the whole path
            // in the ClassHistogramService
            rawPath = rawPath.replace("\"", "");
            if (rawPath.endsWith("\\")) {
                jmapPath = rawPath;
            } else {
                jmapPath = rawPath + "\\";
            }
        } else {
            if (rawPath.endsWith("/")) {
                jmapPath = rawPath;
            } else {
                jmapPath = rawPath + "/";
            }
        }
    }

    @Override
    public boolean enabled() {
        return enabled;
    }

    @Override
    public int classesPerHistogram() {
        return numClassesPerHistogram;
    }

    @Override
    public String jmapPath() {
        return jmapPath;
    }

}
