package com.newrelic.agent.commands;

import java.util.Map;

import com.newrelic.agent.IRPMService;

/**
 * A command takes some action when {@link #process(Map)} is called.
 * 
 * Commands are registered with the {@link CommandParser}.
 * 
 * @author sdaubin
 * 
 */
public interface Command {
    /**
     * The name of this command.
     * 
     * @return
     */
    String getName();

    /**
     * Executes this command. This is called from {@link CommandParser#beforeHarvest(com.newrelic.agent.RPMService)} if
     * it receives a command from the rpm service that matches this command.
     * 
     * @param rpmService the rpm service that received the command
     * @param arguments
     * @return
     * @throws CommandException
     */
    Map process(IRPMService rpmService, Map arguments) throws CommandException;
}
