package com.newrelic.agent.cache;

/**
 * Uniquely identifies a field.
 * 
 */
public final class ClassFieldSignature {

    private final String className;
    private final String fieldName;

    public ClassFieldSignature(String className, String fieldName) {
        this.className = className;
        this.fieldName = fieldName;
    }

    public String getClassName() {
        return className;
    }

    public String getInternalClassName() {
        return className.replace('.', '/');
    }

    public String getFieldName() {
        return fieldName;
    }

    @Override
    public String toString() {
        return new StringBuilder(className).append('.').append(fieldName).toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((className == null) ? 0 : className.hashCode());
        result = prime * result + ((fieldName == null) ? 0 : fieldName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        ClassFieldSignature other = (ClassFieldSignature) obj;
        if (className == null) {
            if (other.className != null) {
                return false;
            }
        } else if (!className.equals(other.className)) {
            return false;
        }
        if (fieldName == null) {
            if (other.fieldName != null) {
                return false;
            }
        } else if (!fieldName.equals(other.fieldName)) {
            return false;
        }
        return true;
    }

    public ClassFieldSignature intern() {
        return new ClassFieldSignature(className.intern(), fieldName.intern());
    }

}
