package com.newrelic.agent.attributes;

import java.util.Map;

import com.newrelic.agent.Transaction;

public class AgentAttributeSender extends AttributeSender {
    protected static String ATTRIBUTE_TYPE = "agent";

    @Override
    protected String getAttributeType() {
        return ATTRIBUTE_TYPE;
    }

    @Override
    protected Map<String, Object> getAttributeMap() throws Throwable {
        Transaction currentTxn = Transaction.getTransaction(false);
        if (currentTxn != null) {
            return currentTxn.getAgentAttributes();
        } else {
            return null;

        }
    }

}