package com.newrelic.agent;

import com.newrelic.agent.service.Service;

/**
 * The interface for the harvest service.
 */
public interface HarvestService extends Service {

    void startHarvest(IRPMService rpmService);

    void stopHarvest(IRPMService rpmService);

    void addHarvestListener(HarvestListener listener);

    void removeHarvestListener(HarvestListener listener);

    void addHarvestable(Harvestable harvestable);

    void removeHarvestable(Harvestable harvestable);

    void removeHarvestablesByAppName(String appName);

    void harvestNow();

}
