/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.SystemPropertyProvider;
import com.newrelic.agent.deps.com.google.common.base.Charsets;
import com.newrelic.agent.deps.com.google.common.io.Files;
import com.newrelic.agent.utilization.CloudUtility;
import com.newrelic.agent.utilization.KubernetesData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataFetcher {
    protected static final Pattern LINUX_MEMORY_PATTERN = Pattern.compile("MemTotal: \\s+(\\d+)\\skB");
    protected static final Pattern LINUX_PROCESSOR_PATTERN = Pattern.compile("processor\\s*:\\s*([0-9]+)");

    public static Callable<Long> getTotalRamInMibCallable() {
        return new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                String os = ManagementFactory.getOperatingSystemMXBean().getName().toLowerCase();
                if (os.contains("linux")) {
                    String match = DataFetcher.findLastMatchInFile(new File("/proc/meminfo"), LINUX_MEMORY_PATTERN);
                    if (match != null) {
                        long ramInkB = DataFetcher.parseLongRam(match);
                        return ramInkB / 1024L;
                    }
                } else {
                    if (os.contains("bsd")) {
                        String output = DataFetcher.executeCommand("sysctl -n hw.realmem");
                        long ramInBytes = DataFetcher.parseLongRam(output);
                        return ramInBytes / 0x100000L;
                    }
                    if (os.contains("mac")) {
                        String output = DataFetcher.executeCommand("sysctl -n hw.memsize");
                        long ramInBytes = DataFetcher.parseLongRam(output);
                        return ramInBytes / 0x100000L;
                    }
                    if (os.contains("windows")) {
                        String output = DataFetcher.executeCommand("wmic ComputerSystem get TotalPhysicalMemory").replaceFirst("TotalPhysicalMemory", "").trim();
                        long ramInBytes = DataFetcher.parseLongRam(output);
                        return ramInBytes / 0x100000L;
                    }
                    Agent.LOG.log(Level.FINER, "Could not get total physical memory for OS {0}", os);
                }
                return 0L;
            }
        };
    }

    public static int getLogicalProcessorCount() {
        int linuxLogicalProcessors;
        String os = ManagementFactory.getOperatingSystemMXBean().getName().toLowerCase();
        if (os.contains("linux") && (linuxLogicalProcessors = DataFetcher.getLinuxLogicalProcessors(new File("/proc/cpuinfo"))) > 0) {
            return linuxLogicalProcessors;
        }
        return ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
    }

    static int getLinuxLogicalProcessors(File procCpuInfo) {
        String match = DataFetcher.findLastMatchInFile(procCpuInfo, LINUX_PROCESSOR_PATTERN);
        if (null != match) {
            try {
                return Integer.parseInt(match) + 1;
            }
            catch (NumberFormatException nfe) {
                Agent.LOG.log(Level.FINE, "Unable to parse linux processors. Found {0}", match);
            }
        }
        return 0;
    }

    public static String getBootId() {
        String os = ManagementFactory.getOperatingSystemMXBean().getName().toLowerCase();
        if (os.contains("linux")) {
            try {
                String bootId = Files.toString(new File("/proc/sys/kernel/random/boot_id"), Charsets.UTF_8).trim();
                if (!CloudUtility.isAscii(bootId)) {
                    Agent.LOG.log(Level.FINE, "Non-ASCII characters in boot_id {0} for OS {1}", bootId, os);
                    DataFetcher.recordBootIdError();
                    return null;
                }
                if (bootId.length() < 36) {
                    Agent.LOG.log(Level.FINE, "Non-standard boot_id {0} for OS {1}", bootId, os);
                    DataFetcher.recordBootIdError();
                } else if (bootId.length() > 128) {
                    Agent.LOG.log(Level.FINE, "Truncating boot_id {0} for OS {1}", bootId, os);
                    DataFetcher.recordBootIdError();
                    bootId = bootId.substring(0, 128);
                }
                return bootId;
            }
            catch (IOException e) {
                DataFetcher.recordBootIdError();
                Agent.LOG.log(Level.FINEST, e, "Exception occurred when reading boot_id file.");
            }
        }
        return null;
    }

    private static void recordBootIdError() {
        CloudUtility.recordError("Supportability/utilization/boot_id/error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findLastMatchInFile(File file, Pattern lookFor) {
        if (file.exists() && file.canRead()) {
            BufferedReader reader = null;
            try {
                String line;
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                reader = new BufferedReader(inputStreamReader);
                Matcher matcher = lookFor.matcher("");
                String lastMatch = null;
                while ((line = reader.readLine()) != null) {
                    matcher.reset(line);
                    if (!matcher.find()) continue;
                    lastMatch = matcher.group(1);
                }
                String string = lastMatch;
                return string;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        Agent.LOG.log(Level.FINER, "Could not read file {0}", file.getName());
        return null;
    }

    protected static long parseLongRam(String number) {
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            Agent.LOG.log(Level.FINE, "Unable to parse total memory available. Found {0}", number);
            return 0L;
        }
    }

    static KubernetesData getKubernetesData(SystemPropertyProvider systemPropertyProvider) {
        try {
            return KubernetesData.extractKubernetesValues(systemPropertyProvider);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, e, "Unable to extract kubernetes metadata.");
            CloudUtility.recordError("Supportability/utilization/kubernetes/error");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeCommand(String command) {
        StringBuffer output = new StringBuffer();
        Process process = null;
        try {
            String line;
            process = Runtime.getRuntime().exec(command);
            BufferedReader procOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = procOutput.readLine()) != null) {
                output.append(line);
            }
            process.waitFor();
        }
        catch (IOException e) {
            Agent.LOG.log(Level.FINEST, e, "An exception occurred running subprocess cmd: {0}", command);
        }
        catch (InterruptedException e) {
            Agent.LOG.log(Level.FINER, "Subprocess cmd interrupted: {0}", command);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return output.toString();
    }
}

