/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.metricname;

import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.util.Strings;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetricNameFormats {
    private static final Cache<MNFKey, MetricNameFormat> cmsToMnf = CacheBuilder.newBuilder().build();
    private static final Pattern METRIC_NAME_REPLACE = Pattern.compile("${className}", 16);

    private MetricNameFormats() {
    }

    public static MetricNameFormat replaceFirstSegment(MetricNameFormat metricName, String newSegmentName) {
        String metricNameString = metricName.getMetricName();
        String txName = metricName.getTransactionSegmentName();
        String newMetricName = MetricNameFormats.replaceFirstSegment(metricNameString, newSegmentName);
        String newTxName = metricNameString.equals(txName) ? newMetricName : MetricNameFormats.replaceFirstSegment(txName, newSegmentName);
        return new SimpleMetricNameFormat(newMetricName, newTxName);
    }

    private static String replaceFirstSegment(String name, String newSegmentName) {
        String[] segments = name.split("/");
        segments[0] = newSegmentName;
        return Strings.join('/', segments);
    }

    public static MetricNameFormat getFormatter(Object invocationTarget, final ClassMethodSignature sig) {
        if (sig == null) {
            return null;
        }
        final MNFKey key = new MNFKey(sig, invocationTarget, null, 0);
        try {
            return cmsToMnf.get(key, new Callable<MetricNameFormat>(){

                @Override
                public MetricNameFormat call() throws Exception {
                    return new ClassMethodMetricNameFormat(sig, key.invocationTargetClassName);
                }
            });
        }
        catch (ExecutionException e) {
            return new ClassMethodMetricNameFormat(sig, key.invocationTargetClassName);
        }
    }

    public static MetricNameFormat getFormatter(Object invocationTarget, final ClassMethodSignature sig, final String metricName, final int flags) {
        if (sig == null) {
            return null;
        }
        final MNFKey key = new MNFKey(sig, invocationTarget, metricName, flags);
        if (metricName == null) {
            try {
                return cmsToMnf.get(key, new Callable<MetricNameFormat>(){

                    @Override
                    public MetricNameFormat call() throws Exception {
                        return sig.getMetricNameFormat(key.invocationTargetClassName, flags);
                    }
                });
            }
            catch (ExecutionException e) {
                return sig.getMetricNameFormat(key.invocationTargetClassName, flags);
            }
        }
        try {
            return cmsToMnf.get(key, new Callable<MetricNameFormat>(){

                @Override
                public MetricNameFormat call() throws Exception {
                    return new SimpleMetricNameFormat(MetricNameFormats.getTracerMetricName(key.invocationTargetClassName, sig.getClassName(), metricName));
                }
            });
        }
        catch (ExecutionException e) {
            return new SimpleMetricNameFormat(MetricNameFormats.getTracerMetricName(key.invocationTargetClassName, sig.getClassName(), metricName));
        }
    }

    private static String getTracerMetricName(String invocationTargetClassName, String className, String metricName) {
        Matcher matcher = METRIC_NAME_REPLACE.matcher(metricName);
        return matcher.replaceFirst(Matcher.quoteReplacement(invocationTargetClassName == null ? className : invocationTargetClassName));
    }

    private static class MNFKey {
        final ClassMethodSignature sig;
        final String invocationTargetClassName;
        final String metricName;
        final int flags;

        MNFKey(ClassMethodSignature sig, Object invocationTarget, String metricName, int flags) {
            this.sig = sig;
            this.invocationTargetClassName = invocationTarget != null ? invocationTarget.getClass().getName() : null;
            this.metricName = metricName;
            this.flags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MNFKey mnfKey = (MNFKey)o;
            if (this.flags != mnfKey.flags) {
                return false;
            }
            if (!this.sig.equals(mnfKey.sig)) {
                return false;
            }
            if (this.invocationTargetClassName != null ? !this.invocationTargetClassName.equals(mnfKey.invocationTargetClassName) : mnfKey.invocationTargetClassName != null) {
                return false;
            }
            return this.metricName != null ? this.metricName.equals(mnfKey.metricName) : mnfKey.metricName == null;
        }

        public int hashCode() {
            int result = this.sig.hashCode();
            result = 31 * result + (this.invocationTargetClassName != null ? this.invocationTargetClassName.hashCode() : 0);
            result = 31 * result + (this.metricName != null ? this.metricName.hashCode() : 0);
            result = 31 * result + this.flags;
            return result;
        }
    }
}

