/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Harvestable;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.SpanEventsServiceImpl;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.StatsWorks;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SpanEventHarvestableImpl
implements Harvestable {
    private final String appName;
    private final SpanEventsServiceImpl spanEventService;
    private long lastHarvest;

    public SpanEventHarvestableImpl(SpanEventsServiceImpl spanEventsService, String appName) {
        this.appName = appName;
        this.lastHarvest = System.nanoTime();
        this.spanEventService = spanEventsService;
    }

    @Override
    public String getEndpointMethodName() {
        return "span_event_data";
    }

    @Override
    public void harvest() {
        this.recordIntervalMetric();
        this.spanEventService.harvestEvents(this.appName);
    }

    @Override
    public void configure(Map<String, Object> configuration) {
        Number reportPeriod = (Number)configuration.get("report_period_in_seconds");
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork("Supportability/Events/TransactionError/ReportPeriod", reportPeriod.longValue()));
        Number maxSamplesCollector = (Number)configuration.get("max_samples_stored");
        int newMaxSamplesStored = maxSamplesCollector != null ? Math.min(maxSamplesCollector.intValue(), 1000) : 1000;
        int currentMaxSamplesStored = this.spanEventService.getMaxSamplesStored();
        if (newMaxSamplesStored != currentMaxSamplesStored) {
            this.spanEventService.harvestEvents(this.appName);
            this.spanEventService.setMaxSamplesStored(newMaxSamplesStored);
        }
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    private void recordIntervalMetric() {
        long startTimeInNanos = System.nanoTime();
        final long harvestIntervalInNanos = startTimeInNanos - this.lastHarvest;
        this.lastHarvest = startTimeInNanos;
        ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

            @Override
            public void doWork(StatsEngine statsEngine) {
                if (harvestIntervalInNanos > 0L) {
                    statsEngine.getResponseTimeStats("Supportability/EventHarvest/SpanEvent/interval").recordResponseTime(harvestIntervalInNanos, TimeUnit.NANOSECONDS);
                }
            }

            @Override
            public String getAppName() {
                return SpanEventHarvestableImpl.this.appName;
            }
        });
    }
}

