/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.api;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableMultimap;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.instrumentation.api.DefaultApiImplementations;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;

public class ApiImplementationUpdate
implements ContextClassTransformer {
    private final DefaultApiImplementations defaultImplementations = new DefaultApiImplementations();
    private final ClassMatchVisitorFactory matcher = new ClassMatchVisitorFactory(){

        @Override
        public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, final InstrumentationContext context) {
            for (String name : reader.getInterfaces()) {
                Map<Method, MethodNode> unmodifiableMethods = ApiImplementationUpdate.this.defaultImplementations.getApiClassNameToDefaultMethods().get(name);
                if (unmodifiableMethods == null) continue;
                final HashMap<Method, MethodNode> methods = Maps.newHashMap(unmodifiableMethods);
                cv = new ClassVisitor(458752, cv){

                    @Override
                    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                        methods.remove(new Method(name, desc));
                        return super.visitMethod(access, name, desc, signature, exceptions);
                    }

                    @Override
                    public void visitEnd() {
                        if (!methods.isEmpty()) {
                            context.putMatch(ApiImplementationUpdate.this.matcher, new OptimizedClassMatcher.Match(ImmutableMultimap.of(), methods.keySet(), null));
                        }
                        super.visitEnd();
                    }
                };
            }
            return cv;
        }
    };

    public static void setup(InstrumentationContextManager manager) throws Exception {
        ApiImplementationUpdate transformer = new ApiImplementationUpdate();
        manager.addContextClassTransformer(transformer.matcher, transformer);
    }

    protected ApiImplementationUpdate() throws Exception {
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
        ClassWriter writer;
        ClassReader reader = new ClassReader(classfileBuffer);
        ClassVisitor cv = writer = new ClassWriter(1);
        for (String name : reader.getInterfaces()) {
            Map<Method, MethodNode> methods = this.defaultImplementations.getApiClassNameToDefaultMethods().get(name);
            if (methods == null) continue;
            final HashMap<Method, MethodNode> methodsToAdd = Maps.newHashMap(methods);
            cv = new ClassVisitor(458752, cv){

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    methodsToAdd.remove(new Method(name, desc));
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }

                @Override
                public void visitEnd() {
                    if (!methodsToAdd.isEmpty()) {
                        HashMap missingMethods = Maps.newHashMap(methodsToAdd);
                        for (Map.Entry entry : missingMethods.entrySet()) {
                            ((MethodNode)entry.getValue()).accept(this);
                        }
                    }
                    super.visitEnd();
                }
            };
        }
        reader.accept(cv, 8);
        return writer.toByteArray();
    }

    protected ClassMatchVisitorFactory getMatcher() {
        return this.matcher;
    }
}

