/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class MultipleExtensionFileFilter
implements FileFilter {
    private final List<String> extensions = new ArrayList<String>();

    public MultipleExtensionFileFilter(String ... pFileExtn) {
        for (String ext : pFileExtn) {
            if (ext != null && ext.length() != 0 && !ext.startsWith(".")) {
                this.extensions.add("." + ext);
                continue;
            }
            this.extensions.add(ext);
        }
    }

    @Override
    public boolean accept(File pFile) {
        if (pFile != null && pFile.isFile() && pFile.canRead()) {
            String name = pFile.getName();
            for (String ext : this.extensions) {
                if (!name.endsWith(ext)) continue;
                return true;
            }
        }
        return false;
    }
}

