/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.AsyncExpirationService;
import com.newrelic.agent.TimedSet;
import com.newrelic.agent.TokenImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.RemovalCause;
import com.newrelic.agent.deps.com.google.common.cache.RemovalListener;
import com.newrelic.agent.deps.com.google.common.cache.RemovalNotification;
import com.newrelic.agent.transaction.TimeoutCause;
import com.newrelic.agent.util.TimeConversion;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class TimedTokenSet
implements TimedSet<TokenImpl> {
    private final AtomicInteger timedOutTokens = new AtomicInteger(0);
    private final Cache<TokenImpl, TokenImpl> activeTokens;

    public TimedTokenSet(int timeOut, TimeUnit unit, final AsyncExpirationService expirationService) {
        long timeOutMilli = TimeConversion.convertToMilliWithLowerBound(timeOut, unit, 250L);
        this.activeTokens = CacheBuilder.newBuilder().concurrencyLevel(8).expireAfterAccess(timeOutMilli, TimeUnit.MILLISECONDS).removalListener(new RemovalListener<TokenImpl, TokenImpl>(){

            @Override
            public void onRemoval(RemovalNotification<TokenImpl, TokenImpl> notification) {
                RemovalCause cause = notification.getCause();
                final TokenImpl token = notification.getKey();
                Transaction tx = token.getTransaction().getTransactionIfExists();
                if (cause == RemovalCause.EXPIRED) {
                    Agent.LOG.log(Level.FINEST, "Timing out token {0} on transaction {1}", token, tx);
                    TimedTokenSet.this.timedOutTokens.incrementAndGet();
                    token.setTruncated();
                    if (tx != null) {
                        tx.setTimeoutCause(TimeoutCause.TOKEN);
                    }
                } else if (cause == RemovalCause.EXPLICIT) {
                    Agent.LOG.log(Level.FINEST, "Expiring token {0} on transaction {1}", token, tx);
                } else {
                    Agent.LOG.log(Level.FINEST, "Token {0} on transaction {1} removed due to cause {2}", token, tx, (Object)cause);
                }
                expirationService.expireToken(new Runnable(){

                    @Override
                    public void run() {
                        token.markExpired();
                    }
                });
            }
        }).build();
    }

    @Override
    public int timedOutCount() {
        return this.timedOutTokens.get();
    }

    @Override
    public boolean remove(TokenImpl token) {
        return this.activeTokens.asMap().remove(token) != null;
    }

    @Override
    public void removeAll() {
        this.activeTokens.invalidateAll();
    }

    @Override
    public void put(TokenImpl token) {
        this.activeTokens.put(token, token);
    }

    @Override
    public void cleanUp() {
        this.activeTokens.cleanUp();
    }

    @Override
    public void refresh(TokenImpl token) {
        this.activeTokens.getIfPresent(token);
    }
}

