/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.HarvestService;
import com.newrelic.agent.Harvestable;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.ServerCommandException;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.metric.MetricIdRegistry;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsEngineImpl;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.SafeWrappers;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class HarvestServiceImpl
extends AbstractService
implements HarvestService {
    public static final String HARVEST_THREAD_NAME = "New Relic Harvest Service";
    private static final long INITIAL_DELAY_IN_MILLISECONDS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    private static final long REPORTING_PERIOD_IN_MILLISECONDS = TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private static final long MIN_HARVEST_INTERVAL_IN_NANOSECONDS = TimeUnit.NANOSECONDS.convert(55L, TimeUnit.SECONDS);
    private static final long DEFAULT_REPORTING_PERIOD_EVENTS_IN_SECONDS = 60L;
    private static final long MAX_REPORTING_PERIOD_EVENTS_IN_SECONDS = 300L;
    @VisibleForTesting
    public static final long MIN_REPORTING_PERIOD_EVENTS_IN_SECONDS = 5L;
    private final ScheduledExecutorService scheduledExecutor;
    private final List<HarvestListener> harvestListeners = new CopyOnWriteArrayList<HarvestListener>();
    private final Map<IRPMService, HarvestTask> harvestTasks = new HashMap<IRPMService, HarvestTask>();
    private final ConcurrentMap<Harvestable, HarvestableTracker> harvestables = Maps.newConcurrentMap();
    private long overrideInitialDelay = -1L;

    public HarvestServiceImpl() {
        super(HarvestService.class.getSimpleName());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(HARVEST_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        ServiceFactory.getRPMServiceManager().addConnectionListener(new ConnectionListenerImpl());
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
    }

    @Override
    public void startHarvest(IRPMService rpmService) {
        HarvestTask harvestTask = this.getOrCreateHarvestTask(rpmService);
        harvestTask.start();
    }

    @VisibleForTesting
    public void startHarvestables(IRPMService rpmService, AgentConfig config) {
        HashMap dataMethods = (HashMap)config.getProperty("data_methods");
        dataMethods = dataMethods == null ? Maps.newHashMap() : Maps.newHashMap(dataMethods);
        for (HarvestableTracker tracker : this.harvestables.values()) {
            if (!tracker.harvestable.getAppName().equals(rpmService.getApplicationName())) continue;
            HashMap<String, Object> map = (HashMap<String, Object>)dataMethods.remove(tracker.harvestable.getEndpointMethodName());
            if (map == null) {
                map = Maps.newHashMap();
            }
            this.putHarvestCyclePeriodForEvents(map);
            tracker.start(ImmutableMap.copyOf(map), this.getInitialDelay());
        }
        if (!dataMethods.isEmpty()) {
            Agent.LOG.log(Level.FINE, "Unexpected data methods: {0}", dataMethods.keySet());
        }
    }

    private void putHarvestCyclePeriodForEvents(Map<String, Object> map) {
        long harvestCycle;
        if (!map.containsKey("report_period_in_seconds")) {
            harvestCycle = 60L;
        } else {
            harvestCycle = ((Number)map.get("report_period_in_seconds")).longValue();
            if (harvestCycle < 5L || harvestCycle > 300L) {
                Agent.LOG.log(Level.FINE, "Unexpected value: {0} for harvest cycle reporting period", harvestCycle);
                ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/EventHarvest/ReportPeriod/Invalid", 1));
            }
            if (harvestCycle <= 0L) {
                harvestCycle = 60L;
            } else if (harvestCycle >= 1L && harvestCycle <= 4L) {
                harvestCycle = 5L;
            } else if (harvestCycle > 300L) {
                harvestCycle = 300L;
            }
        }
        map.put("report_period_in_seconds", harvestCycle);
    }

    @Override
    public void stopHarvest(IRPMService rpmService) {
        HarvestTask harvestTask = this.harvestTasks.remove(rpmService);
        if (harvestTask != null) {
            harvestTask.stop();
        }
    }

    private synchronized HarvestTask getOrCreateHarvestTask(IRPMService rpmService) {
        HarvestTask harvestTask = this.harvestTasks.get(rpmService);
        if (harvestTask == null) {
            harvestTask = new HarvestTask(rpmService);
            this.harvestTasks.put(rpmService, harvestTask);
        }
        return harvestTask;
    }

    private synchronized List<HarvestTask> getHarvestTasks() {
        return new ArrayList<HarvestTask>(this.harvestTasks.values());
    }

    @Override
    public void addHarvestable(Harvestable harvestable) {
        HarvestableTracker existing = this.harvestables.putIfAbsent(harvestable, new HarvestableTracker(harvestable));
        if (existing != null) {
            Agent.LOG.log(Level.SEVERE, "Harvestable already added to the harvest service: {0}", harvestable);
            existing.stop();
        }
    }

    @Override
    public void removeHarvestable(Harvestable harvestable) {
        HarvestableTracker tracker;
        if (harvestable != null && (tracker = (HarvestableTracker)this.harvestables.remove(harvestable)) != null) {
            tracker.stop();
        }
    }

    @Override
    public void removeHarvestablesByAppName(String appName) {
        for (HarvestableTracker tracker : this.harvestables.values()) {
            if (!tracker.harvestable.getAppName().equals(appName)) continue;
            this.harvestables.remove(tracker.harvestable);
            if (tracker == null) continue;
            tracker.stop();
        }
    }

    @Override
    public void addHarvestListener(HarvestListener listener) {
        this.harvestListeners.add(listener);
    }

    @Override
    public void removeHarvestListener(HarvestListener listener) {
        this.harvestListeners.remove(listener);
    }

    @Override
    protected void doStop() {
        List<HarvestTask> tasks = this.getHarvestTasks();
        for (HarvestTask task : tasks) {
            task.stop();
        }
        for (HarvestableTracker h : this.harvestables.values()) {
            h.stop();
        }
        this.scheduledExecutor.shutdown();
    }

    private ScheduledFuture<?> scheduleHarvestTask(HarvestTask harvestTask) {
        return this.scheduledExecutor.scheduleAtFixedRate(SafeWrappers.safeRunnable(harvestTask), this.getInitialDelay(), this.getReportingPeriod(), TimeUnit.MILLISECONDS);
    }

    public long getInitialDelay() {
        return this.overrideInitialDelay <= 0L ? INITIAL_DELAY_IN_MILLISECONDS : this.overrideInitialDelay;
    }

    @VisibleForTesting
    public void setInitialDelayMillis(long millis) {
        this.overrideInitialDelay = millis;
    }

    public long getReportingPeriod() {
        return REPORTING_PERIOD_IN_MILLISECONDS;
    }

    public long getMinHarvestInterval() {
        return MIN_HARVEST_INTERVAL_IN_NANOSECONDS;
    }

    @Override
    public void harvestNow() {
        List<HarvestTask> tasks = this.getHarvestTasks();
        for (HarvestTask task : tasks) {
            for (HarvestableTracker h : this.harvestables.values()) {
                h.harvestable.harvest();
            }
            task.harvestNow();
        }
    }

    private void reportHarvest(String appName, StatsEngine statsEngine, IRPMService rpmService) {
        try {
            rpmService.harvest(statsEngine);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error reporting harvest data for {0}: {1}", appName, e);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, msg, e);
            }
            this.getLogger().finer(msg);
        }
    }

    private void notifyListenerBeforeHarvest(String appName, StatsEngine statsEngine, HarvestListener listener) {
        try {
            listener.beforeHarvest(appName, statsEngine);
        }
        catch (Throwable e) {
            String msg = MessageFormat.format("Error harvesting data for {0}: {1}", appName, e);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, msg, e);
            }
            this.getLogger().finer(msg);
        }
    }

    private void notifyListenerAfterHarvest(String appName, HarvestListener listener) {
        try {
            listener.afterHarvest(appName);
        }
        catch (Throwable e) {
            String msg = MessageFormat.format("Error harvesting data for {0}: {1}", appName, e);
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.FINER, msg, e);
            }
            this.getLogger().finer(msg);
        }
    }

    private class ConnectionListenerImpl
    implements ConnectionListener {
        private ConnectionListenerImpl() {
        }

        @Override
        public void connected(IRPMService rpmService, AgentConfig agentConfig) {
            HarvestServiceImpl.this.startHarvest(rpmService);
            HarvestServiceImpl.this.startHarvestables(rpmService, agentConfig);
        }

        @Override
        public void disconnected(IRPMService rpmService) {
            for (HarvestableTracker h : HarvestServiceImpl.this.harvestables.values()) {
                h.stop();
            }
        }
    }

    private class HarvestableTracker {
        private final Harvestable harvestable;
        private final List<ScheduledFuture<?>> tasks = Lists.newArrayList();

        public HarvestableTracker(Harvestable harvestable) {
            this.harvestable = harvestable;
        }

        public synchronized void start(Map<String, Object> configuration, long initialDelay) {
            this.stop();
            this.harvestable.configure(configuration);
            long reportPeriodInMillis = TimeUnit.SECONDS.toMillis(((Number)configuration.get("report_period_in_seconds")).longValue());
            Runnable harvestTask = new Runnable(){

                @Override
                public void run() {
                    HarvestServiceImpl.this.getLogger().log(Level.FINER, "Harvestable: {0}/{1} running", HarvestableTracker.this.harvestable.getAppName(), HarvestableTracker.this.harvestable.getEndpointMethodName());
                    HarvestableTracker.this.harvestable.harvest();
                }
            };
            this.tasks.add(HarvestServiceImpl.this.scheduledExecutor.scheduleAtFixedRate(SafeWrappers.safeRunnable(harvestTask), initialDelay, reportPeriodInMillis, TimeUnit.MILLISECONDS));
        }

        public synchronized void stop() {
            for (ScheduledFuture<?> task : this.tasks) {
                task.cancel(false);
            }
            this.tasks.clear();
        }
    }

    private final class HarvestTask
    implements Runnable {
        private final IRPMService rpmService;
        private ScheduledFuture<?> task;
        private final Lock harvestLock = new ReentrantLock();
        private StatsEngine lastStatsEngine = new StatsEngineImpl();
        private long lastHarvestStartTime;

        private HarvestTask(IRPMService rpmService) {
            this.rpmService = rpmService;
        }

        @Override
        public void run() {
            try {
                if (this.shouldHarvest()) {
                    this.harvest();
                }
            }
            catch (Throwable t) {
                String msg = MessageFormat.format("Unexpected exception during harvest: {0}", t);
                if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINER)) {
                    HarvestServiceImpl.this.getLogger().log(Level.WARNING, msg, t);
                }
                HarvestServiceImpl.this.getLogger().warning(msg);
            }
        }

        private boolean shouldHarvest() {
            return System.nanoTime() - this.lastHarvestStartTime >= HarvestServiceImpl.this.getMinHarvestInterval();
        }

        private synchronized void start() {
            if (!this.isRunning()) {
                this.stop();
                String msg = MessageFormat.format("Scheduling harvest task for {0}", this.rpmService.getApplicationName());
                HarvestServiceImpl.this.getLogger().log(Level.FINE, msg);
                this.task = HarvestServiceImpl.this.scheduleHarvestTask(this);
            }
        }

        private synchronized void stop() {
            if (this.task != null) {
                HarvestServiceImpl.this.getLogger().fine(MessageFormat.format("Cancelling harvest task for {0}", this.rpmService.getApplicationName()));
                this.task.cancel(false);
            }
        }

        private boolean isRunning() {
            if (this.task == null) {
                return false;
            }
            return !this.task.isCancelled() || this.task.isDone();
        }

        private void harvestNow() {
            if (this.rpmService.isConnected()) {
                String msg = MessageFormat.format("Sending metrics for {0} immediately", this.rpmService.getApplicationName());
                HarvestServiceImpl.this.getLogger().info(msg);
                this.harvest();
            }
        }

        private void harvest() {
            this.harvestLock.lock();
            try {
                this.doHarvest();
            }
            catch (ServerCommandException serverCommandException) {
            }
            catch (IgnoreSilentlyException ignoreSilentlyException) {
            }
            catch (Throwable e) {
                HarvestServiceImpl.this.getLogger().log(Level.INFO, "Error sending metric data for {0}: {1}", this.rpmService.getApplicationName(), e.toString());
            }
            finally {
                this.harvestLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doHarvest() throws Exception {
            long duration;
            this.lastHarvestStartTime = System.nanoTime();
            String appName = this.rpmService.getApplicationName();
            if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINE)) {
                String msg = MessageFormat.format("Starting harvest for {0}", appName);
                HarvestServiceImpl.this.getLogger().fine(msg);
                String linkText = this.rpmService.getApplicationLink();
                String version = Agent.getVersion();
                String reportingToAndVersion = MessageFormat.format("Application link: {0}, Agent version: {1}", linkText, version);
                HarvestServiceImpl.this.getLogger().fine(reportingToAndVersion);
            }
            StatsEngine harvestStatsEngine = ServiceFactory.getStatsService().getStatsEngineForHarvest(appName);
            harvestStatsEngine.mergeStats(this.lastStatsEngine);
            try {
                for (HarvestListener listener : HarvestServiceImpl.this.harvestListeners) {
                    HarvestServiceImpl.this.notifyListenerBeforeHarvest(appName, harvestStatsEngine, listener);
                }
                HarvestServiceImpl.this.reportHarvest(appName, harvestStatsEngine, this.rpmService);
                for (HarvestListener listener : HarvestServiceImpl.this.harvestListeners) {
                    HarvestServiceImpl.this.notifyListenerAfterHarvest(appName, listener);
                }
                if (harvestStatsEngine.getSize() > MetricIdRegistry.METRIC_LIMIT) {
                    harvestStatsEngine.clear();
                }
                this.lastStatsEngine = harvestStatsEngine;
                duration = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.lastHarvestStartTime, TimeUnit.NANOSECONDS);
                harvestStatsEngine.getResponseTimeStats("Supportability/Harvest").recordResponseTime(duration, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
                if (harvestStatsEngine.getSize() > MetricIdRegistry.METRIC_LIMIT) {
                    harvestStatsEngine.clear();
                }
                this.lastStatsEngine = harvestStatsEngine;
                long duration2 = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.lastHarvestStartTime, TimeUnit.NANOSECONDS);
                harvestStatsEngine.getResponseTimeStats("Supportability/Harvest").recordResponseTime(duration2, TimeUnit.MILLISECONDS);
                if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINE)) {
                    String msg = MessageFormat.format("Harvest for {0} took {1} milliseconds", appName, duration2);
                    HarvestServiceImpl.this.getLogger().fine(msg);
                }
                throw throwable;
            }
            if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINE)) {
                String msg = MessageFormat.format("Harvest for {0} took {1} milliseconds", appName, duration);
                HarvestServiceImpl.this.getLogger().fine(msg);
            }
        }
    }
}

