/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.SpanImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionApiImpl;
import com.newrelic.agent.bridge.Agent;
import com.newrelic.agent.bridge.NoOpMetricAggregator;
import com.newrelic.agent.bridge.NoOpSpan;
import com.newrelic.agent.bridge.NoOpTracedMethod;
import com.newrelic.agent.bridge.NoOpTransaction;
import com.newrelic.agent.bridge.Span;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.Config;
import com.newrelic.api.agent.Insights;
import com.newrelic.api.agent.Logger;
import com.newrelic.api.agent.MetricAggregator;
import java.util.logging.Level;

public class AgentImpl
implements Agent {
    private final Logger logger;

    public AgentImpl(Logger logger) {
        this.logger = logger;
    }

    public TracedMethod getTracedMethod() {
        com.newrelic.agent.bridge.Transaction transaction = this.getTransaction(false);
        if (!NoOpTransaction.INSTANCE.equals(transaction)) {
            Transaction txn = Transaction.getTransaction(false);
            if (txn == null) {
                return NoOpTracedMethod.INSTANCE;
            }
            TransactionActivity txa = txn.getTransactionActivity();
            if (txa == null) {
                return NoOpTracedMethod.INSTANCE;
            }
            Tracer tracer = txa.getLastTracer();
            return tracer == null ? NoOpTracedMethod.INSTANCE : tracer;
        }
        return NoOpTracedMethod.INSTANCE;
    }

    public com.newrelic.agent.bridge.Transaction getTransaction() {
        Transaction innerTx;
        Transaction txn = Transaction.getTransaction(false);
        TransactionActivity txa = TransactionActivity.get();
        if (null != txa) {
            Tracer tracer = txa.getRootTracer();
            if (txn == null && tracer != null && tracer.isAsync()) {
                return NoOpTransaction.INSTANCE;
            }
        }
        if ((innerTx = Transaction.getTransaction(false)) != null) {
            return TransactionApiImpl.INSTANCE;
        }
        return NoOpTransaction.INSTANCE;
    }

    public com.newrelic.agent.bridge.Transaction getTransaction(boolean createIfNotExists) {
        if (null == Transaction.getTransaction(createIfNotExists)) {
            return null;
        }
        return this.getTransaction();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Config getConfig() {
        return ServiceFactory.getConfigService().getDefaultAgentConfig();
    }

    public MetricAggregator getMetricAggregator() {
        try {
            Transaction tx = Transaction.getTransaction(false);
            if (null != tx && tx.isInProgress()) {
                return tx.getMetricAggregator();
            }
            return ServiceFactory.getStatsService().getMetricAggregator();
        }
        catch (Throwable t) {
            com.newrelic.agent.Agent.LOG.log(Level.FINE, "getMetricAggregator() call failed : {0}", t.getMessage());
            com.newrelic.agent.Agent.LOG.log(Level.FINEST, t, "getMetricAggregator() call failed");
            return NoOpMetricAggregator.INSTANCE;
        }
    }

    public Insights getInsights() {
        return ServiceFactory.getServiceManager().getInsights();
    }

    public boolean startAsyncActivity(Object activityContext) {
        return ServiceFactory.getAsyncTxService().startAsyncActivity(activityContext);
    }

    public boolean ignoreIfUnstartedAsyncContext(Object activityContext) {
        return ServiceFactory.getAsyncTxService().ignoreIfUnstartedAsyncContext(activityContext);
    }

    public Span startSpan(String name) {
        try {
            if (!ServiceFactory.getConfigService().getDefaultAgentConfig().getSpanEventsConfig().isEnabled()) {
                return NoOpSpan.INSTANCE;
            }
            return new SpanImpl(name);
        }
        catch (Throwable t) {
            com.newrelic.agent.Agent.LOG.log(Level.FINE, "startSpan() call failed for name: {0}, {1}", name, t.getMessage());
            com.newrelic.agent.Agent.LOG.log(Level.FINEST, t, "startSpan() call failed for name: {0}", name);
            return NoOpSpan.INSTANCE;
        }
    }
}

