/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Deployments;
import com.newrelic.agent.command.XmlInstrumentOptions;
import com.newrelic.agent.command.XmlInstrumentValidator;
import com.newrelic.agent.deps.org.apache.commons.cli.CommandLine;
import com.newrelic.agent.deps.org.apache.commons.cli.HelpFormatter;
import com.newrelic.agent.deps.org.apache.commons.cli.Option;
import com.newrelic.agent.deps.org.apache.commons.cli.Options;
import com.newrelic.agent.deps.org.apache.commons.cli.ParseException;
import com.newrelic.agent.deps.org.apache.commons.cli.PosixParser;
import com.newrelic.agent.install.AppServerIdentifier;
import com.newrelic.agent.install.ConfigInstaller;
import com.newrelic.agent.install.SelfInstaller;
import com.newrelic.agent.install.SelfInstallerFactory;
import com.newrelic.weave.verification.WeavePackageVerifier;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

class AgentCommandLineParser {
    private static final String INSTALL_COMMAND = "install";
    private static final String DEPLOYMENT_COMMAND = "deployment";
    private static final String VERIFY_INSTRUMENTATION = "verifyInstrumentation";
    private static final String INSTRUMENT_COMMAND = "instrument";
    private static final Map<String, Options> commandOptionsMap = new HashMap<String, Options>();
    private static final Map<String, String> commandDescriptions;

    AgentCommandLineParser() {
    }

    public void parseCommand(String[] args) {
        PosixParser parser = new PosixParser();
        try {
            String command;
            CommandLine cmd = parser.parse(AgentCommandLineParser.getCommandLineOptions(), args);
            List argList = cmd.getArgList();
            String string = command = argList.size() > 0 ? (String)argList.get(0) : null;
            if (cmd.hasOption('h')) {
                this.printHelp(command);
                return;
            }
            if (command != null) {
                Options commandOptions = commandOptionsMap.get(command);
                if (commandOptions == null) {
                    this.printHelp();
                    System.err.println("\nInvalid command - " + command);
                    System.exit(1);
                }
                cmd = parser.parse(commandOptions, args);
            }
            if (DEPLOYMENT_COMMAND.equals(command)) {
                this.deploymentCommand(cmd);
            } else if (INSTALL_COMMAND.equals(command)) {
                this.installCommand(cmd);
            } else if (INSTRUMENT_COMMAND.equals(command)) {
                this.instrumentCommand(cmd);
            } else if (VERIFY_INSTRUMENTATION.equals(command)) {
                this.verifyInstrumentation(cmd);
            } else if (cmd.hasOption('v') || cmd.hasOption("version")) {
                System.out.println(Agent.getVersion());
            } else {
                this.printHelp();
                System.exit(1);
            }
        }
        catch (ParseException e) {
            System.err.println("Error parsing arguments");
            this.printHelp();
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Error executing command");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void instrumentCommand(CommandLine cmd) throws Exception {
        XmlInstrumentValidator.validateInstrumentation(cmd);
    }

    private void deploymentCommand(CommandLine cmd) throws Exception {
        Deployments.recordDeployment(cmd);
    }

    private void installCommand(CommandLine cmd) throws Exception {
        System.out.println("***** ( ( o))  New Relic Java Agent Installer" + SelfInstaller.lineSep);
        System.out.println("***** Installing version " + Agent.getVersion() + " ..." + SelfInstaller.lineSep);
        File newRelicDir = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
        File appServerDir = null;
        if (cmd.getOptionValue('s') != null) {
            appServerDir = new File(cmd.getOptionValue('s'));
        }
        if (appServerDir == null || !appServerDir.exists() || !appServerDir.isDirectory()) {
            appServerDir = newRelicDir.getParentFile();
        }
        appServerDir = appServerDir.getCanonicalFile();
        boolean startup_patched = false;
        boolean config_installed = false;
        AppServerIdentifier.AppServerType type = AppServerIdentifier.getAppServerType(appServerDir);
        if (type == null || type == AppServerIdentifier.AppServerType.UNKNOWN) {
            this.printUnknownAppServer(appServerDir);
        } else {
            SelfInstaller installer = SelfInstallerFactory.getSelfInstaller(type);
            if (installer != null) {
                startup_patched = installer.backupAndEditStartScript(appServerDir.toString());
            }
        }
        if (newRelicDir.exists() && newRelicDir.isDirectory()) {
            if (ConfigInstaller.isConfigInstalled(newRelicDir)) {
                System.out.println("* No need to create New Relic configuration file because:");
                System.out.println(MessageFormat.format(" A config file already exists: {0}", ConfigInstaller.configPath(newRelicDir) + SelfInstaller.lineSep));
                config_installed = true;
            } else {
                try {
                    ConfigInstaller.install(cmd.getOptionValue('l'), newRelicDir);
                    config_installed = true;
                    System.out.println("* Generated New Relic configuration file " + ConfigInstaller.configPath(newRelicDir) + SelfInstaller.lineSep);
                }
                catch (IOException e) {
                    System.err.println(MessageFormat.format("An error occurred generating the configuration file {0} : {1}", ConfigInstaller.configPath(newRelicDir), e.toString()));
                    Agent.LOG.log(Level.FINE, "Config file generation error", e);
                }
            }
        } else {
            System.err.println("* Could not create New Relic configuration file because:");
            System.err.println(MessageFormat.format("{0} does not exist or is not a directory", newRelicDir.getAbsolutePath() + SelfInstaller.lineSep));
        }
        if (startup_patched && config_installed) {
            this.printInstallSuccess();
            System.exit(0);
        } else {
            this.printInstallIncomplete();
            System.exit(1);
        }
    }

    private void printInstallSuccess() {
        System.out.println("***** Install successful" + SelfInstaller.lineSep);
        System.out.println("***** Next steps:");
        System.out.println("You're almost done! To see performance data for your app:" + SelfInstaller.lineSep + SelfInstaller.lineSep + "1) Restart your app server" + SelfInstaller.lineSep + "2) Exercise your app" + SelfInstaller.lineSep + "3) Log into http://rpm.newrelic.com" + SelfInstaller.lineSep + SelfInstaller.lineSep + "Within two minutes, your app should show up, ready to monitor and troubleshoot." + SelfInstaller.lineSep + "If app data doesn't appear, check newrelic/logs/newrelic_agent.log for errors.");
    }

    private void printInstallIncomplete() {
        System.out.println("***** Install incomplete" + SelfInstaller.lineSep);
        System.out.println("***** Next steps:");
        System.out.println("For help completing the install, see https://newrelic.com/docs/java/new-relic-for-java");
    }

    private void printUnknownAppServer(File appServerLoc) {
        StringBuilder knownAppServers = new StringBuilder();
        for (int i = 0; i < AppServerIdentifier.AppServerType.values().length - 1; ++i) {
            AppServerIdentifier.AppServerType type = AppServerIdentifier.AppServerType.values()[i];
            knownAppServers.append(type.getName());
            if (i < AppServerIdentifier.AppServerType.values().length - 3) {
                knownAppServers.append(", ");
                continue;
            }
            if (i != AppServerIdentifier.AppServerType.values().length - 3) continue;
            knownAppServers.append(" or ");
        }
        System.out.println("* Could not edit start script because:");
        System.out.println("Could not locate a " + knownAppServers.toString() + " instance in " + appServerLoc.toString() + SelfInstaller.lineSep);
        System.out.println("* Try re-running the install command with the -s <AppServerRootDirectory> option or from <AppServerRootDirectory>" + SelfInstaller.fileSep + "newrelic.");
        System.out.println("If that doesn't work, locate and edit the start script manually." + SelfInstaller.lineSep);
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        System.out.println(MessageFormat.format("New Relic Agent Version {0}", Agent.getVersion()));
        formatter.printHelp("java -jar newrelic.jar", "", AgentCommandLineParser.getBasicOptions(), this.getCommandLineFooter());
    }

    private void printHelp(String command) {
        if (command == null) {
            this.printHelp();
            return;
        }
        HelpFormatter formatter = new HelpFormatter();
        System.out.println(MessageFormat.format("New Relic Agent Version {0}", Agent.getVersion()));
        String footer = "\n  " + command + ' ' + commandDescriptions.get(command);
        formatter.printHelp("java -jar newrelic.jar " + command, "", commandOptionsMap.get(command), footer);
    }

    private void verifyInstrumentation(CommandLine cmd) {
        List args = cmd.getArgList().subList(1, cmd.getArgList().size());
        WeavePackageVerifier.main(args.toArray(new String[args.size()]));
    }

    private String getCommandLineFooter() {
        int maxCommandLength = this.getMaxCommandLength();
        String minSpaces = "    ";
        StringBuilder builder = new StringBuilder("\nCommands:");
        for (Map.Entry<String, String> entry : commandDescriptions.entrySet()) {
            String extraSpaces = new String(new char[maxCommandLength - entry.getKey().length()]).replace('\u0000', ' ');
            builder.append("\n  ").append(entry.getKey()).append(extraSpaces).append(minSpaces).append(entry.getValue());
        }
        return builder.toString();
    }

    private int getMaxCommandLength() {
        int max = 0;
        for (String command : commandDescriptions.keySet()) {
            max = Math.max(max, command.length());
        }
        return max;
    }

    static Options getCommandLineOptions() {
        ArrayList<Options> values = new ArrayList<Options>(Collections.singletonList(AgentCommandLineParser.getBasicOptions()));
        values.addAll(commandOptionsMap.values());
        return AgentCommandLineParser.combineOptions(values);
    }

    private static Options combineOptions(Collection<Options> optionsList) {
        Options newOptions = new Options();
        for (Options options : optionsList) {
            for (Option option : options.getOptions()) {
                newOptions.addOption(option);
            }
        }
        return newOptions;
    }

    private static Options getBasicOptions() {
        Options options = new Options();
        options.addOption("v", false, "Prints the agent version");
        options.addOption("version", false, "Prints the agent version");
        options.addOption("h", false, "Prints help");
        return options;
    }

    private static Options getInstallOptions() {
        Options options = new Options();
        options.addOption("l", true, "Use the given license key");
        options.addOption("s", true, "Path to application server");
        return options;
    }

    private static Options getDeploymentOptions() {
        Options options = new Options();
        options.addOption("appname", true, "Set the application name.  Default is app_name setting in newrelic.yml");
        options.addOption("environment", true, "Set the environment (staging, production, test, development)");
        options.addOption("user", true, "Specify the user deploying");
        options.addOption("revision", true, "Specify the revision being deployed");
        options.addOption("changes", false, "Reads the change log for a deployment from standard input");
        return options;
    }

    private static Options getInstrumentOptions() {
        XmlInstrumentOptions[] instrumentOps;
        Options options = new Options();
        for (XmlInstrumentOptions op : instrumentOps = XmlInstrumentOptions.values()) {
            options.addOption(op.getFlagName(), op.isArgRequired(), op.getDescription());
        }
        return options;
    }

    private static Options getVerifyInstrumentationOptions() {
        Options options = new Options();
        return options;
    }

    static {
        commandOptionsMap.put(DEPLOYMENT_COMMAND, AgentCommandLineParser.getDeploymentOptions());
        commandOptionsMap.put(INSTALL_COMMAND, AgentCommandLineParser.getInstallOptions());
        commandOptionsMap.put(INSTRUMENT_COMMAND, AgentCommandLineParser.getInstrumentOptions());
        commandOptionsMap.put(VERIFY_INSTRUMENTATION, AgentCommandLineParser.getVerifyInstrumentationOptions());
        commandDescriptions = new HashMap<String, String>();
        commandDescriptions.put(DEPLOYMENT_COMMAND, "[OPTIONS] [description]  Records a deployment");
        commandDescriptions.put(INSTALL_COMMAND, "[OPTIONS]                Generates a newrelic.yml configuration with the given license key and attempts to integrate with app server");
        commandDescriptions.put(INSTRUMENT_COMMAND, "[OPTIONS]                Validates a custom instrumentation xml configuration file.");
    }
}

