/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.weave.utils.ClassFinder;
import com.newrelic.weave.utils.WeaveUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Set;

public abstract class BootstrapLoader
implements ClassFinder {
    public static final ClassLoader PLACEHOLER = new ClassLoader(null){

        public String toString() {
            return "BoostrapPlaceholder";
        }
    };
    private static final BootstrapLoader loader = BootstrapLoader.create();

    public static BootstrapLoader get() {
        return loader;
    }

    private static BootstrapLoader create() {
        try {
            return new BootstrapLoaderImpl();
        }
        catch (Exception e) {
            try {
                return new IBMBootstrapLoader();
            }
            catch (Exception exception) {
                return new BootstrapLoader(){

                    @Override
                    public URL findResource(String name) {
                        return null;
                    }

                    @Override
                    public boolean isBootstrapClass(String internalName) {
                        return internalName.startsWith("java/");
                    }
                };
            }
        }
    }

    public boolean isBootstrapClass(String internalOrClassName) {
        URL bootstrapResource = this.findResource(WeaveUtils.getClassResourceName(internalOrClassName));
        return bootstrapResource != null;
    }

    @Override
    public abstract URL findResource(String var1);

    private static class IBMBootstrapLoader
    extends BootstrapLoader {
        private static final Set<String> BOOTSTRAP_CLASSLOADER_FIELDS = ImmutableSet.of("bootstrapClassLoader", "systemClassLoader");
        private final ClassLoader bootstrapLoader;

        public IBMBootstrapLoader() throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
            ClassLoader cl;
            Field field = this.getBootstrapField();
            field.setAccessible(true);
            this.bootstrapLoader = cl = (ClassLoader)field.get(null);
        }

        private Field getBootstrapField() throws NoSuchFieldException {
            for (String fieldName : BOOTSTRAP_CLASSLOADER_FIELDS) {
                try {
                    Field field = ClassLoader.class.getDeclaredField(fieldName);
                    return field;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (SecurityException securityException) {
                }
            }
            throw new NoSuchFieldException(MessageFormat.format("No bootstrap fields found: {0}", BOOTSTRAP_CLASSLOADER_FIELDS));
        }

        @Override
        public URL findResource(String name) {
            return this.bootstrapLoader.getResource(WeaveUtils.getClassResourceName(name));
        }
    }

    private static class BootstrapLoaderImpl
    extends BootstrapLoader {
        private final Method getBootstrapResourceMethod = ClassLoader.class.getDeclaredMethod("getBootstrapResource", String.class);

        private BootstrapLoaderImpl() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.getBootstrapResourceMethod.setAccessible(true);
            this.getBootstrapResourceMethod.invoke(null, "dummy");
        }

        @Override
        public URL findResource(String internalOrClassName) {
            try {
                return (URL)this.getBootstrapResourceMethod.invoke(null, WeaveUtils.getClassResourceName(internalOrClassName));
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

