/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.apache.http.client.config.RequestConfig;
import com.newrelic.agent.deps.org.apache.http.client.methods.CloseableHttpResponse;
import com.newrelic.agent.deps.org.apache.http.client.methods.HttpGet;
import com.newrelic.agent.deps.org.apache.http.config.SocketConfig;
import com.newrelic.agent.deps.org.apache.http.conn.ConnectTimeoutException;
import com.newrelic.agent.deps.org.apache.http.conn.ssl.StrictHostnameVerifier;
import com.newrelic.agent.deps.org.apache.http.impl.client.CloseableHttpClient;
import com.newrelic.agent.deps.org.apache.http.impl.client.HttpClientBuilder;
import com.newrelic.agent.deps.org.apache.http.util.EntityUtils;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class AWS {
    protected static final String INSTANCE_TYPE_URL = "http://169.254.169.254/2008-02-01/meta-data/instance-type";
    protected static final String INSTANCE_ID_URL = "http://169.254.169.254/2008-02-01/meta-data/instance-id";
    protected static final String INSTANCE_AVAILABLITY_ZONE = "http://169.254.169.254/2008-02-01/meta-data/placement/availability-zone";
    private static int requestTimeoutInMillis = 100;
    private static final int MIN_CHAR_CODEPOINT = "\u007f".codePointAt(0);

    protected AwsData getAwsData() {
        String zone;
        String type = this.getAwsValue(INSTANCE_TYPE_URL);
        String id = type == null ? null : this.getAwsValue(INSTANCE_ID_URL);
        String string = zone = type == null && id == null ? null : this.getAwsValue(INSTANCE_AVAILABLITY_ZONE);
        if (type == null || id == null || zone == null) {
            return AwsData.EMPTY_DATA;
        }
        return new AwsData(id, type, zone);
    }

    protected String getAwsValue(String url) {
        try {
            String value = this.makeHttpRequest(url);
            if (this.isInvalidAwsValue(value)) {
                Agent.LOG.log(Level.WARNING, MessageFormat.format("Failed to validate AWS value {0}", value));
                AWS.recordAwsError();
                return null;
            }
            return value.trim();
        }
        catch (ConnectTimeoutException value) {
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, MessageFormat.format("Error occurred trying to get AWS value. {0}", t));
            AWS.recordAwsError();
        }
        return null;
    }

    protected boolean isInvalidAwsValue(String value) {
        if (value == null) {
            return true;
        }
        if (value.getBytes().length > 255) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ' ' || c == '_' || c == '.' || c == '/' || c == '-' || c > MIN_CHAR_CODEPOINT) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String makeHttpRequest(String url) throws IOException {
        CloseableHttpClient httpclient = null;
        try {
            httpclient = AWS.configureHttpClient();
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpclient.execute(httpGet);
            if (response.getStatusLine().getStatusCode() <= 207) {
                String string = EntityUtils.toString(response.getEntity(), "UTF-8");
                return string;
            }
        }
        finally {
            if (httpclient != null) {
                try {
                    httpclient.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static CloseableHttpClient configureHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(requestTimeoutInMillis).setSoKeepAlive(true).build());
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setConnectTimeout(requestTimeoutInMillis).setConnectionRequestTimeout(requestTimeoutInMillis).setSocketTimeout(requestTimeoutInMillis);
        builder.setDefaultRequestConfig(requestBuilder.build());
        builder.setHostnameVerifier(new StrictHostnameVerifier());
        return builder.build();
    }

    private static void recordAwsError() {
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork("Supportability/utilization/aws/error", 1));
    }

    protected static class AwsData {
        private final String instanceId;
        private final String instanceType;
        private final String availablityZone;
        static final AwsData EMPTY_DATA = new AwsData();

        private AwsData() {
            this.instanceId = null;
            this.instanceType = null;
            this.availablityZone = null;
        }

        protected AwsData(String id, String type, String zone) {
            this.instanceId = id;
            this.instanceType = type;
            this.availablityZone = zone;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public String getAvailabityZone() {
            return this.availablityZone;
        }
    }
}

