/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.trace.ITransactionSampler;
import com.newrelic.agent.trace.TransactionTrace;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;

public class TransactionTraceSampler
implements ITransactionSampler {
    private static final int NO_TRACE_LIMIT = 5;
    private volatile Map<String, Long> tracedTransactions;
    private final AtomicReference<TransactionData> expensiveTransaction = new AtomicReference();
    private final int topN = ServiceFactory.getConfigService().getDefaultAgentConfig().getTransactionTracerConfig().getTopN();
    private int noTraceCount;
    private final Lock readLock;
    private final Lock writeLock;

    public TransactionTraceSampler() {
        this.tracedTransactions = Collections.unmodifiableMap(new HashMap(this.topN));
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noticeTransaction(TransactionData td) {
        if (!this.exceedsThreshold(td)) {
            return false;
        }
        TransactionData maxTrace = this.expensiveTransaction.get();
        if (maxTrace != null && this.getScore(maxTrace) >= this.getScore(td)) {
            return false;
        }
        this.readLock.lock();
        try {
            boolean bl = this.noticeTransactionUnderLock(td);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean noticeTransactionUnderLock(TransactionData td) {
        TransactionData current;
        Long lastScore = this.tracedTransactions.get(td.getBlameMetricName());
        if (lastScore != null && this.getScore(td) <= lastScore) {
            return false;
        }
        do {
            if ((current = this.expensiveTransaction.get()) == null || this.getScore(current) < this.getScore(td)) continue;
            return false;
        } while (!this.expensiveTransaction.compareAndSet(current, td));
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Captured expensive transaction trace for {0} {1}", td.getApplicationName(), td);
            Agent.LOG.finer(msg);
        }
        return true;
    }

    protected boolean exceedsThreshold(TransactionData td) {
        if (td.getLegacyDuration() > td.getTransactionTracerConfig().getTransactionThresholdInNanos()) {
            return true;
        }
        Agent.LOG.log(Level.FINER, "Transaction trace threshold not exceeded {0}", new Object[]{td});
        return false;
    }

    protected long getScore(TransactionData td) {
        return td.getLegacyDuration();
    }

    @Override
    public List<TransactionTrace> harvest(String appName) {
        TransactionData td = null;
        this.writeLock.lock();
        try {
            td = this.harvestUnderLock(appName);
        }
        finally {
            this.writeLock.unlock();
        }
        if (td == null) {
            return Collections.emptyList();
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Sending transaction trace for {0} {1}", td.getApplicationName(), td);
            Agent.LOG.finer(msg);
        }
        TransactionTrace trace = TransactionTrace.getTransactionTrace(td);
        ArrayList<TransactionTrace> traces = new ArrayList<TransactionTrace>(1);
        traces.add(trace);
        return traces;
    }

    private TransactionData harvestUnderLock(String appName) {
        TransactionData td = this.expensiveTransaction.getAndSet(null);
        if (this.topN == 0) {
            return td;
        }
        if (td == null) {
            this.checkAndClearTracedTransactions();
        } else {
            this.noticeTracedTransaction(td);
        }
        return td;
    }

    private void checkAndClearTracedTransactions() {
        ++this.noTraceCount;
        if (this.noTraceCount >= 5 && !this.tracedTransactions.isEmpty()) {
            this.noTraceCount = 0;
            this.tracedTransactions = Collections.unmodifiableMap(new HashMap(this.topN));
        }
    }

    private void noticeTracedTransaction(TransactionData td) {
        this.noTraceCount = 0;
        HashMap<String, Long> ttMap = new HashMap<String, Long>(this.topN);
        if (this.tracedTransactions.size() < this.topN) {
            ttMap.putAll(this.tracedTransactions);
        }
        ttMap.put(td.getBlameMetricName(), this.getScore(td));
        this.tracedTransactions = Collections.unmodifiableMap(ttMap);
    }

    @Override
    public void stop() {
        this.expensiveTransaction.set(null);
        this.tracedTransactions = Collections.unmodifiableMap(new HashMap(this.topN));
    }
}

