/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.commands.AbstractCommand;
import com.newrelic.agent.commands.CommandException;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.service.module.ClassMetadataFiles;
import com.newrelic.agent.service.module.JarCollectorServiceProcessor;
import com.newrelic.agent.service.module.Module;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class SendModuleMetadataCommand
extends AbstractCommand {
    private final JarCollectorServiceProcessor processor;

    public SendModuleMetadataCommand(JarCollectorServiceProcessor processor) {
        super("send_module_metadata");
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map process(IRPMService rpmService, Map arguments) throws CommandException {
        List checksums = (List)arguments.get("module_checksums");
        HashMap<String, URL> checksumToUrl = Maps.newHashMap(this.processor.getSha1ChecksumToURL());
        checksumToUrl.keySet().retainAll(checksums);
        HashMap response = Maps.newHashMap();
        ArrayList<File> jars = Lists.newArrayList();
        try {
            for (Map.Entry entry : checksumToUrl.entrySet()) {
                try {
                    File file = ClassMetadataFiles.createClassMetadataFile((URL)entry.getValue());
                    jars.add(file);
                    Module module = new Module((String)entry.getKey(), file);
                    Agent.LOG.log(Level.FINER, "Sending module metadata with checksum {0} from {1}", new Object[]{entry.getKey(), file.getAbsolutePath()});
                    try {
                        rpmService.sendModuleMetadata(module);
                        response.put(entry.getKey(), "success");
                    }
                    catch (Exception e) {
                        response.put(entry.getKey(), e.getMessage());
                    }
                }
                catch (IOException e) {
                    Agent.LOG.log(Level.FINEST, e, "{0}", new Object[]{e.getMessage()});
                    response.put(entry.getKey(), e.getMessage());
                }
            }
            checksums.removeAll(response.keySet());
            for (String checksum : checksums) {
                response.put(checksum, "missing");
            }
            HashMap hashMap = response;
            return hashMap;
        }
        finally {
            for (File jar : jars) {
                jar.delete();
            }
        }
    }
}

