/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;

abstract class TransactionEventsConfigUtils {
    public static final int DEFAULT_MAX_SAMPLES_STORED = 2000;
    public static final boolean DEFAULT_ENABLED = true;

    TransactionEventsConfigUtils() {
    }

    static boolean isTransactionEventsEnabled(AgentConfig config, int maxSamplesStored) {
        return maxSamplesStored > 0 && (Boolean)config.getValue("analytics_events.enabled", true) != false && (Boolean)config.getValue("transaction_events.enabled", true) != false && (Boolean)config.getValue("transaction_events.collect_analytics_events", true) != false;
    }

    static int getMaxSamplesStored(AgentConfig config) {
        Integer newMax = (Integer)config.getValue("transaction_events.max_samples_stored");
        if (newMax != null) {
            return newMax;
        }
        Integer oldMax = (Integer)config.getValue("analytics_events.max_samples_stored", 2000);
        if (oldMax != null) {
            Agent.LOG.info("The property analytics_events.max_samples_stored is deprecated. Please use transaction_events.max_samples_stored.");
            return oldMax;
        }
        return 2000;
    }
}

