/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.service.ServiceUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class FixedSizeArrayList<E>
implements List<E> {
    private final Object[] data;
    private final AtomicInteger volatileMemoryBarrier = new AtomicInteger(0);
    protected final int size;
    protected final AtomicInteger numberOfTries = new AtomicInteger();

    public FixedSizeArrayList(int size) {
        this.data = new Object[size];
        this.size = size;
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        ServiceUtils.readMemoryBarrier(this.volatileMemoryBarrier);
        return (E)this.data[index];
    }

    @Override
    public boolean add(E t) {
        Integer slot = this.getSlot();
        if (slot == null) {
            return false;
        }
        this.set(slot, t);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            modified |= this.add(e);
        }
        return modified;
    }

    @Override
    public E set(int slot, E element) {
        this.rangeCheck(slot);
        ServiceUtils.readMemoryBarrier(this.volatileMemoryBarrier);
        Object oldValue = this.data[slot];
        this.data[slot] = element;
        ServiceUtils.writeMemoryBarrier(this.volatileMemoryBarrier);
        return (E)oldValue;
    }

    private void rangeCheck(int index) {
        if (index >= this.data.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.data.length);
        }
    }

    public Integer getSlot() {
        int insertIndex = this.numberOfTries.getAndIncrement();
        if (insertIndex >= this.data.length) {
            return null;
        }
        return insertIndex;
    }

    public int getNumberOfTries() {
        return this.numberOfTries.get();
    }

    @Override
    public int size() {
        return Math.min(this.data.length, this.numberOfTries.get());
    }

    @Override
    public boolean isEmpty() {
        return this.numberOfTries.get() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor != FixedSizeArrayList.this.size();
            }

            @Override
            public E next() {
                int i = this.cursor;
                if (i >= FixedSizeArrayList.this.size()) {
                    throw new NoSuchElementException();
                }
                this.cursor = i + 1;
                ServiceUtils.readMemoryBarrier(FixedSizeArrayList.this.volatileMemoryBarrier);
                return FixedSizeArrayList.this.data[i];
            }

            @Override
            public void remove() {
                Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
            }
        };
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.data, this.size());
    }

    @Override
    public boolean contains(Object o) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return false;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return null;
    }

    @Override
    public boolean remove(Object o) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return false;
    }

    @Override
    public void clear() {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
    }

    @Override
    public void add(int index, E element) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
    }

    @Override
    public E remove(int index) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return null;
    }

    @Override
    public int indexOf(Object o) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return null;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return null;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        Agent.LOG.log(Level.FINE, new UnsupportedOperationException(), "Method not implemented.", new Object[0]);
        return null;
    }
}

