/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.install;

import com.newrelic.agent.Agent;
import com.newrelic.agent.util.Strings;
import com.newrelic.weave.utils.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;

public class ConfigInstaller {
    private static final String REPLACE_WITH_YOUR_LICENSE_KEY = "replace_with_your_license_key";
    private static final String LICENSE_KEY_CONFIG_PARAM = "<%= license_key %>";
    private static final String GENERATE_FOR_USER_CONFIG_PARAM = "<%= generated_for_user %>";

    public static boolean isConfigInstalled(File configDir) {
        if (configDir != null && configDir.exists() && configDir.isDirectory()) {
            return new File(configDir, "newrelic.yml").exists();
        }
        return false;
    }

    public static String configPath(File configDir) {
        return new File(configDir, "newrelic.yml").getAbsolutePath();
    }

    public static void install(String licenseKey, File configDir) throws Exception {
        ConfigInstaller.generateConfig(licenseKey == null ? REPLACE_WITH_YOUR_LICENSE_KEY : licenseKey, configDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateConfig(String licenseKey, File configDir) throws Exception {
        block7: {
            InputStream inStream = ConfigInstaller.class.getClassLoader().getResourceAsStream("newrelic.yml");
            if (inStream != null) {
                String generatedFrom = ConfigInstaller.getGeneratedFromString();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try {
                    Streams.copy(inStream, output);
                    String yaml = output.toString().replace(GENERATE_FOR_USER_CONFIG_PARAM, generatedFrom).replace(LICENSE_KEY_CONFIG_PARAM, licenseKey);
                    FileOutputStream fileOut = new FileOutputStream(ConfigInstaller.configPath(configDir));
                    try {
                        Streams.copy((InputStream)new ByteArrayInputStream(yaml.getBytes()), (OutputStream)fileOut, yaml.getBytes().length);
                        break block7;
                    }
                    finally {
                        fileOut.close();
                    }
                }
                finally {
                    inStream.close();
                }
            }
            throw new IOException("Unable to open newrelic.yml template");
        }
    }

    private static String getGeneratedFromString() {
        return MessageFormat.format("Generated on {0}, from version {1}", new Date(), Agent.getVersion());
    }

    public static boolean isLicenseKeyEmpty(String license) {
        return license == null || license.equals(REPLACE_WITH_YOUR_LICENSE_KEY) || license.equals(LICENSE_KEY_CONFIG_PARAM) || Strings.isEmpty(license) || Strings.isEmpty(license.trim());
    }
}

