/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.ch.qos.logback.core.util;

import com.newrelic.agent.deps.ch.qos.logback.core.Context;
import com.newrelic.agent.deps.ch.qos.logback.core.spi.ContextAwareBase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class ContextUtil
extends ContextAwareBase {
    public ContextUtil(Context context) {
        this.setContext(context);
    }

    static String getLocalHostName() throws UnknownHostException {
        InetAddress localhost = InetAddress.getLocalHost();
        return localhost.getHostName();
    }

    public void addHostNameAsProperty() {
        try {
            String localhostName = ContextUtil.getLocalHostName();
            this.context.putProperty("HOSTNAME", localhostName);
        }
        catch (UnknownHostException e) {
            this.addError("Failed to get local hostname", e);
        }
        catch (SecurityException e) {
            this.addError("Failed to get local hostname", e);
        }
    }

    public void addProperties(Properties props) {
        if (props == null) {
            return;
        }
        for (String string : props.keySet()) {
            this.context.putProperty(string, props.getProperty(string));
        }
    }
}

