/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.ch.qos.logback.classic.util;

import com.newrelic.agent.deps.ch.qos.logback.classic.LoggerContext;
import com.newrelic.agent.deps.ch.qos.logback.core.spi.ContextAware;
import com.newrelic.agent.deps.ch.qos.logback.core.spi.LifeCycle;
import com.newrelic.agent.deps.ch.qos.logback.core.status.OnConsoleStatusListener;
import com.newrelic.agent.deps.ch.qos.logback.core.status.StatusListener;
import com.newrelic.agent.deps.ch.qos.logback.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    static void installIfAsked(LoggerContext loggerContext) {
        String slClass = OptionHelper.getSystemProperty("logback.statusListenerClass");
        if (!OptionHelper.isEmpty(slClass)) {
            StatusListenerConfigHelper.addStatusListener(loggerContext, slClass);
        }
    }

    static void addStatusListener(LoggerContext loggerContext, String listenerClass) {
        StatusListener listener = null;
        if ("SYSOUT".equalsIgnoreCase(listenerClass)) {
            listener = new OnConsoleStatusListener();
        } else {
            try {
                listener = (StatusListener)OptionHelper.instantiateByClassName(listenerClass, StatusListener.class, loggerContext);
                if (listener instanceof ContextAware) {
                    ((ContextAware)((Object)listener)).setContext(loggerContext);
                }
                if (listener instanceof LifeCycle) {
                    ((LifeCycle)((Object)listener)).start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (listener != null) {
            loggerContext.getStatusManager().add(listener);
        }
    }
}

