/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.AgentCommandLineParser;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.InitProblemClasses;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.PrivateApiImpl;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.JarResource;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.install.ConfigInstaller;
import com.newrelic.agent.logging.AgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceManagerImpl;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.util.asm.ClassStructure;
import com.newrelic.api.agent.NewRelicApiImplementation;
import com.newrelic.bootstrap.BootstrapLoader;
import com.newrelic.weave.utils.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;

public final class Agent
extends AbstractService
implements IAgent {
    public static final IAgentLogger LOG = AgentLogManager.getLogger();
    private static final String NEWRELIC_BOOTSTRAP = "newrelic-bootstrap";
    private static final String AGENT_ENABLED_PROPERTY = "newrelic.config.agent_enabled";
    private static final boolean DEBUG = Boolean.getBoolean("newrelic.debug");
    private static final String VERSION = Agent.initVersion();
    private static long agentPremainTime;
    private volatile boolean enabled = true;
    private final Instrumentation instrumentation;
    private volatile InstrumentationProxy instrumentationProxy;
    private static volatile boolean canFastPath;

    private Agent(Instrumentation instrumentation) {
        super(IAgent.class.getSimpleName());
        this.instrumentation = instrumentation;
    }

    @Override
    protected void doStart() {
        ConfigService configService = ServiceFactory.getConfigService();
        AgentConfig config = configService.getDefaultAgentConfig();
        AgentLogManager.configureLogger(config);
        this.logHostIp();
        LOG.info(MessageFormat.format("New Relic Agent v{0} is initializing...", Agent.getVersion()));
        this.enabled = config.isAgentEnabled();
        if (!this.enabled) {
            LOG.info("New Relic agent is disabled.");
        }
        if (config.liteMode()) {
            LOG.info("New Relic agent is running in lite mode. All instrumentation modules are disabled");
            StatsService statsService = ServiceFactory.getServiceManager().getStatsService();
            statsService.getMetricAggregator().incrementCounter("Supportability/litemode");
        }
        this.instrumentationProxy = InstrumentationProxy.getInstrumentationProxy(this.instrumentation);
        this.initializeBridgeApis();
        final long startTime = System.currentTimeMillis();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Agent.this.jvmShutdown(startTime);
            }
        };
        Thread shutdownThread = new Thread(runnable, "New Relic JVM Shutdown");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    private void initializeBridgeApis() {
        NewRelicApiImplementation.initialize();
        PrivateApiImpl.initialize(LOG);
    }

    private void logHostIp() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            LOG.info("Agent Host: " + address.getHostName() + " IP: " + address.getHostAddress());
        }
        catch (UnknownHostException e) {
            LOG.info("New Relic could not identify host/ip.");
        }
    }

    @Override
    protected void doStop() {
    }

    @Override
    public void shutdownAsync() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Agent.this.shutdown();
            }
        };
        Thread shutdownThread = new Thread(runnable, "New Relic Shutdown");
        shutdownThread.start();
    }

    private void jvmShutdown(long startTime) {
        this.getLogger().fine("Agent JVM shutdown hook: enter.");
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        if (config.isSendDataOnExit() && System.currentTimeMillis() - startTime >= config.getSendDataOnExitThresholdInMillis()) {
            ServiceFactory.getRPMService().harvestNow();
        }
        this.getLogger().info("JVM is shutting down");
        this.shutdown();
        this.getLogger().fine("Agent JVM shutdown hook: done.");
    }

    private synchronized void shutdown() {
        try {
            ServiceFactory.getServiceManager().stop();
            this.getLogger().info("New Relic Agent has shutdown");
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, t, "Error shutting down New Relic Agent", new Object[0]);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public InstrumentationProxy getInstrumentation() {
        return this.instrumentationProxy;
    }

    public static String getVersion() {
        return VERSION;
    }

    private static String initVersion() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(Agent.class.getName());
            return bundle.getString("version");
        }
        catch (Throwable throwable) {
            return "0.0";
        }
    }

    public static boolean isDebugEnabled() {
        return DEBUG;
    }

    public static boolean canFastPath() {
        return canFastPath;
    }

    public static void disableFastPath() {
        if (canFastPath) {
            canFastPath = false;
        }
    }

    public static void premain(String agentArgs, Instrumentation inst, long startTime) {
        Agent.addMixinInterfacesToBootstrap(inst);
        if (ServiceFactory.getServiceManager() != null) {
            LOG.warning("New Relic Agent is already running! Check if more than one -javaagent switch is used on the command line.");
            return;
        }
        String enabled = System.getProperty(AGENT_ENABLED_PROPERTY);
        if (enabled != null && !Boolean.parseBoolean(enabled.toString())) {
            LOG.warning("New Relic Agent is disabled by a system property.");
            return;
        }
        String jvmName = System.getProperty("java.vm.name");
        if (jvmName.contains("Oracle JRockit")) {
            String msg = MessageFormat.format("New Relic Agent {0} does not support the Oracle JRockit JVM (\"{1}\").", Agent.getVersion(), jvmName);
            LOG.warning(msg);
        }
        try {
            ServiceManagerImpl serviceManager;
            try {
                Agent agent = new Agent(inst);
                serviceManager = new ServiceManagerImpl(agent);
                ServiceFactory.setServiceManager(serviceManager);
                if (ConfigInstaller.isLicenseKeyEmpty(serviceManager.getConfigService().getDefaultAgentConfig().getLicenseKey())) {
                    LOG.error("license_key is empty in the config. Not starting New Relic Agent.");
                    return;
                }
                if (!serviceManager.getConfigService().getDefaultAgentConfig().isAgentEnabled()) {
                    LOG.warning("agent_enabled is false in the config. Not starting New Relic Agent.");
                    return;
                }
                InitProblemClasses.loadInitialClasses();
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, t, "Unable to start the New Relic Agent. Your application will continue to run but it will not be monitored.", new Object[0]);
                return;
            }
            serviceManager.start();
            LOG.info(MessageFormat.format("New Relic Agent v{0} has started", Agent.getVersion()));
            if (System.getProperty("newrelic.bootstrap_classpath") != null) {
                LOG.info("The \"newrelic.bootstrap_classpath\" property is no longer used. Please remove it from your configuration.");
            }
            LOG.info("Agent class loader: " + AgentBridge.getAgent().getClass().getClassLoader());
            if (serviceManager.getConfigService().getDefaultAgentConfig().isStartupTimingEnabled()) {
                Agent.recordPremainTime(serviceManager.getStatsService(), startTime);
            }
        }
        catch (Throwable t) {
            String msg = "Unable to start New Relic Agent. Please remove -javaagent from your startup arguments and contact New Relic support.";
            try {
                LOG.log(Level.SEVERE, t, msg, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.err.println(msg);
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.5")) {
            String msg = MessageFormat.format("Java version is: {0}.  This version of the New Relic Agent does not support Java 1.5.  Please use a 2.21.x New Relic agent or a later version of Java.", javaVersion);
            System.err.println("----------");
            System.err.println(msg);
            System.err.println("----------");
            return;
        }
        if (javaVersion.startsWith("9")) {
            boolean java9enabled;
            boolean bl = java9enabled = System.getProperty("newrelic.enable.java.9") != null;
            if (!java9enabled) {
                String msg = MessageFormat.format("Java version is: {0}.  This version of the New Relic Agent does not support Java 9. Please use an earlier version of Java.", javaVersion);
                System.err.println("----------");
                System.err.println(msg);
                System.err.println("----------");
                return;
            }
        }
        new AgentCommandLineParser().parseCommand(args);
    }

    public static long getAgentPremainTimeInMillis() {
        return agentPremainTime;
    }

    private static void recordPremainTime(StatsService statsService, long startTime) {
        agentPremainTime = System.currentTimeMillis() - startTime;
        LOG.log(Level.INFO, "Premain startup complete in {0}ms", new Object[]{agentPremainTime});
        statsService.doStatsWork(StatsWorks.getRecordResponseTimeWork("Supportability/Timing/Premain", agentPremainTime));
        ImmutableMap<String, Long> environmentInfo = ImmutableMap.builder().put("Duration", agentPremainTime).put("Version", (Long)((Object)Agent.getVersion())).put("JRE Vendor", (Long)((Object)System.getProperty("java.vendor"))).put("JRE Version", (Long)((Object)System.getProperty("java.version"))).put("JVM Vendor", (Long)((Object)System.getProperty("java.vm.vendor"))).put("JVM Version", (Long)((Object)System.getProperty("java.vm.version"))).put("JVM Runtime Version", (Long)((Object)System.getProperty("java.runtime.version"))).put("OS Name", (Long)((Object)System.getProperty("os.name"))).put("OS Version", (Long)((Object)System.getProperty("os.version"))).put("OS Arch", (Long)((Object)System.getProperty("os.arch"))).put("Processors", (Long)Runtime.getRuntime().availableProcessors()).put("Free Memory", Runtime.getRuntime().freeMemory()).put("Total Memory", Runtime.getRuntime().totalMemory()).put("Max Memory", Runtime.getRuntime().maxMemory()).build();
        LOG.log(Level.FINE, "Premain environment info: {0}", new Object[]{((Object)environmentInfo).toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addMixinInterfacesToBootstrap(Instrumentation inst) {
        if (Agent.isDisableMixinsOnBootstrap()) {
            System.out.println("New Relic Agent: mixin interfaces not moved to bootstrap");
            return;
        }
        JarResource agentJarResource = null;
        try {
            agentJarResource = AgentJarHelper.getAgentJarResource();
            URL agentJarUrl = AgentJarHelper.getAgentJarUrl();
            Agent.addMixinInterfacesToBootstrap(agentJarResource, agentJarUrl, inst);
        }
        finally {
            try {
                agentJarResource.close();
            }
            catch (Throwable th) {
                Agent.logIfNRDebug("closing Agent jar resource", th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMixinInterfacesToBootstrap(JarResource agentJarResource, URL agentJarUrl, Instrumentation inst) {
        boolean succeeded = false;
        Pattern packageSearchPattern = Pattern.compile("com/newrelic/agent/instrumentation/pointcuts/(.*).class");
        String interfaceMixinAnnotation = "Lcom/newrelic/agent/instrumentation/pointcuts/InterfaceMixin;";
        String loadOnBootstrapAnnotation = "Lcom/newrelic/agent/instrumentation/pointcuts/LoadOnBootstrap;";
        String interfaceMapperAnnotation = "Lcom/newrelic/agent/instrumentation/pointcuts/InterfaceMapper;";
        String methodMapperAnnotation = "Lcom/newrelic/agent/instrumentation/pointcuts/MethodMapper;";
        String fieldAccessorAnnotation = "Lcom/newrelic/agent/instrumentation/pointcuts/FieldAccessor;";
        List<String> bootstrapAnnotations = Arrays.asList("Lcom/newrelic/agent/instrumentation/pointcuts/InterfaceMixin;", "Lcom/newrelic/agent/instrumentation/pointcuts/InterfaceMapper;", "Lcom/newrelic/agent/instrumentation/pointcuts/MethodMapper;", "Lcom/newrelic/agent/instrumentation/pointcuts/FieldAccessor;", "Lcom/newrelic/agent/instrumentation/pointcuts/LoadOnBootstrap;");
        File generatedFile = null;
        ZipOutputStream outputJarStream = null;
        try {
            generatedFile = File.createTempFile(NEWRELIC_BOOTSTRAP, ".jar", BootstrapLoader.getTempDir());
            Manifest manifest = Agent.createManifest();
            outputJarStream = Agent.createJarOutputStream(generatedFile, manifest);
            long modTime = System.currentTimeMillis();
            Collection<String> fileNames = AgentJarHelper.findJarFileNames(agentJarUrl, packageSearchPattern);
            for (String fileName : fileNames) {
                int size = (int)agentJarResource.getSize(fileName);
                ByteArrayOutputStream out = new ByteArrayOutputStream(size);
                Streams.copy(agentJarResource.getInputStream(fileName), out, size, true);
                byte[] classBytes = out.toByteArray();
                ClassReader cr = new ClassReader(classBytes);
                ClassStructure structure = ClassStructure.getClassStructure(cr, 4);
                Set<String> annotations = structure.getClassAnnotations().keySet();
                if (!Agent.containsAnyOf(bootstrapAnnotations, annotations)) continue;
                JarEntry entry = new JarEntry(fileName);
                entry.setTime(modTime);
                ((JarOutputStream)outputJarStream).putNextEntry(entry);
                outputJarStream.write(classBytes);
            }
            outputJarStream.closeEntry();
            succeeded = true;
        }
        catch (IOException iox) {
            Agent.logIfNRDebug("generating mixin jar file", iox);
        }
        finally {
            try {
                outputJarStream.close();
            }
            catch (Throwable th) {
                Agent.logIfNRDebug("closing outputJarStream", th);
            }
        }
        if (succeeded) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(generatedFile);
                inst.appendToBootstrapClassLoaderSearch(jarFile);
                generatedFile.deleteOnExit();
            }
            catch (IOException iox) {
                Agent.logIfNRDebug("adding dynamic mixin jar to bootstrap", iox);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Throwable th) {
                    Agent.logIfNRDebug("closing generated jar file", th);
                }
            }
        }
    }

    private static final boolean containsAnyOf(Collection<?> searchFor, Collection<?> searchIn) {
        for (Object key : searchFor) {
            if (!searchIn.contains(key)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isDisableMixinsOnBootstrap() {
        String newrelicDisableMixinsOnBootstrap = "newrelic.disable.mixins.on.bootstrap";
        return System.getProperty(newrelicDisableMixinsOnBootstrap) != null && Boolean.getBoolean(newrelicDisableMixinsOnBootstrap);
    }

    private static final void logIfNRDebug(String msg, Throwable th) {
        if (Agent.isDebugEnabled()) {
            System.out.println("While bootstrapping the Agent: " + msg + ": " + th.getStackTrace());
        }
    }

    private static final JarOutputStream createJarOutputStream(File jarFile, Manifest manifest) throws IOException {
        FileOutputStream outStream = new FileOutputStream(jarFile);
        return new JarOutputStream((OutputStream)outStream, manifest);
    }

    private static final Manifest createManifest() {
        Manifest manifest = new Manifest();
        Attributes a = manifest.getMainAttributes();
        a.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        a.put(Attributes.Name.IMPLEMENTATION_TITLE, "Interface Mixins");
        a.put(Attributes.Name.IMPLEMENTATION_VERSION, "1.0");
        a.put(Attributes.Name.IMPLEMENTATION_VENDOR, "New Relic");
        return manifest;
    }

    static {
        canFastPath = true;
    }
}

