/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import com.newrelic.agent.compile.ClassData;
import com.newrelic.agent.compile.ClassMethod;
import com.newrelic.agent.compile.ClassRemapperConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class InstrumentationContext {
    private final ClassRemapperConfig config;
    private final Logger log;
    private boolean classModified;
    private String className;
    private String superClassName;
    private final ArrayList<String> tags = new ArrayList();
    private final HashMap<String, String> tracedMethods;
    private final HashMap<String, String> skippedMethods;
    private final HashMap<String, ArrayList<String>> tracedMethodParameters = new HashMap();
    private String variantName;
    private int computeFlags;

    public InstrumentationContext(ClassRemapperConfig config, Logger log) {
        this.config = config;
        this.log = log;
        this.tracedMethods = new HashMap();
        this.skippedMethods = new HashMap();
        this.variantName = "release";
        this.computeFlags = 0;
    }

    public Logger getLog() {
        return this.log;
    }

    public void reset() {
        this.classModified = false;
        this.className = "";
        this.superClassName = "";
        this.tags.clear();
        this.computeFlags = 0;
    }

    public void markModified() {
        this.classModified = true;
    }

    public boolean isClassModified() {
        return this.classModified;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addUniqueTag(String tag) {
        while (this.tags.remove(tag)) {
        }
        this.addTag(tag);
    }

    public void addTracedMethod(String name, String desc) {
        this.log.debug("Will trace method [" + this.className + "#" + name + ":" + desc + "] as requested");
        this.tracedMethods.put(this.className + "#" + name, desc);
    }

    public void addSkippedMethod(String name, String desc) {
        this.log.debug("Will skip all tracing in method [" + this.className + "#" + name + ":" + desc + "] as requested");
        this.skippedMethods.put(this.className + "#" + name, desc);
    }

    public void addTracedMethodParameter(String methodName, String parameterName, String parameterClass, String parameterValue) {
        this.log.debug("Adding traced method parameter [" + parameterName + "] for method [" + methodName + "]");
        String name = this.className + "#" + methodName;
        if (!this.tracedMethodParameters.containsKey(name)) {
            this.tracedMethodParameters.put(name, new ArrayList());
        }
        ArrayList<String> methodParameters = this.tracedMethodParameters.get(name);
        methodParameters.add(parameterName);
        methodParameters.add(parameterClass);
        methodParameters.add(parameterValue);
    }

    public ArrayList<String> getTracedMethodParameters(String methodName) {
        return this.tracedMethodParameters.get(this.className + "#" + methodName);
    }

    public boolean isTracedMethod(String name, String desc) {
        return this.searchMethodMap(this.tracedMethods, name, desc);
    }

    public boolean isSkippedMethod(String name, String desc) {
        return this.searchMethodMap(this.skippedMethods, name, desc);
    }

    private boolean searchMethodMap(Map<String, String> map, String name, String desc) {
        String descToMatch = map.get(this.className + "#" + name);
        if (descToMatch == null) {
            return false;
        }
        return desc.equals(descToMatch);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public void setClassName(String className) {
        this.className = className == null ? "" : className;
    }

    public String getClassName() {
        return this.className == null ? "" : this.className;
    }

    public String getFriendlyClassName() {
        return this.className.replaceAll("/", ".");
    }

    public String getFriendlySuperClassName() {
        return this.superClassName.replaceAll("/", ".");
    }

    public String getSimpleClassName() {
        if (this.className.contains("/")) {
            return this.className.substring(this.className.lastIndexOf("/") + 1);
        }
        return this.className;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName == null ? "" : superClassName;
    }

    public String getSuperClassName() {
        return this.superClassName == null ? "" : this.superClassName;
    }

    public ClassData newClassData(byte[] mainClassBytes) {
        return new ClassData(mainClassBytes, this.isClassModified());
    }

    public ClassMethod getMethodWrapper(ClassMethod method) {
        return this.config.getMethodWrapper(method);
    }

    public Collection<ClassMethod> getCallSiteReplacements(String className, String methodName, String methodDesc) {
        return this.config.getCallSiteReplacements(className, methodName, methodDesc);
    }

    public Collection<ClassMethod> getShadowMethods(String className, String methodName, String methodDesc) {
        return this.config.getShadowMethods(className, methodName, methodDesc);
    }

    public String getVariantName() {
        return this.variantName == null ? "release" : this.variantName;
    }

    public void setVariantName(String variantName) {
        if (variantName != null && !variantName.isEmpty()) {
            this.variantName = variantName.toLowerCase();
        }
    }

    public void setComputeFlags(int computeFlags) {
        this.computeFlags = computeFlags;
    }

    public int getComputeFlags() {
        return this.computeFlags;
    }
}

