/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.compile;

import com.newrelic.agent.InstrumentationAgent;
import com.newrelic.agent.compile.ClassData;
import com.newrelic.agent.compile.InvocationDispatcher;
import com.newrelic.agent.util.FileUtils;
import com.newrelic.agent.util.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.slf4j.Logger;

public final class ClassTransformer {
    public static final String MANIFEST_TRANSFORMED_BY_KEY = "Transformed-By";
    public static final String MANIFEST_SHA_DIGEST_REGEX = "^SHA-.*-Digest$";
    private final Logger log = InstrumentationAgent.LOGGER;
    private File inputFile = new File(".").getAbsoluteFile();
    private File outputFile = new File(".").getAbsoluteFile();
    private ClassData classData = null;
    private boolean identityTransform = false;
    private WriteMode writeMode = WriteMode.modified;
    final InvocationDispatcher invocationDispatcher = this.initDispatcher();

    private InvocationDispatcher initDispatcher() {
        try {
            return new InvocationDispatcher(this.log);
        }
        catch (Exception e) {
            this.log.error("ClassTransformer: could not allocate InvocationDispatcher! " + e);
            return null;
        }
    }

    public ClassTransformer() {
    }

    public ClassTransformer(File classPath, File outputDir) {
        this();
        this.inputFile = classPath;
        this.outputFile = outputDir;
        if (classPath.isDirectory()) {
            this.inputFile = classPath;
        }
    }

    public ClassTransformer(JarFile jarFile, File outputJar) {
        this();
        File jar = new File(jarFile.getName());
        this.inputFile = jar.getParentFile();
        this.outputFile = outputJar;
    }

    public byte[] transformClassBytes(String classPathname, byte[] bytes) {
        if (FileUtils.isClass(classPathname) && !this.identityTransform) {
            try {
                if (bytes != null) {
                    this.classData = this.invocationDispatcher.visitClassBytes(bytes);
                    if (this.classData != null && this.classData.getClassBytes() != null && this.classData.isModified()) {
                        return this.classData.getClassBytes();
                    }
                }
            }
            catch (Exception e) {
                this.log.error("[ClassTransformer] " + e);
            }
        }
        return null;
    }

    public ByteArrayInputStream transformClassByteStream(String classFilePath, InputStream classFileInputStream) throws IOException {
        ByteArrayInputStream processedClassBytesStream;
        byte[] classBytes = Streams.slurpBytes(classFileInputStream);
        byte[] transformedClassBytes = this.transformClassBytes(classFilePath, classBytes);
        if (transformedClassBytes == null) {
            processedClassBytesStream = new ByteArrayInputStream(classBytes);
        } else {
            if (classBytes.length != transformedClassBytes.length && this.classData != null && this.classData.isModified()) {
                this.log.debug("[ClassTransformer] Rewrote class[" + classFilePath + "] bytes[" + classBytes.length + "] rewritten[" + transformedClassBytes.length + "]");
            }
            processedClassBytesStream = new ByteArrayInputStream(transformedClassBytes);
        }
        return processedClassBytesStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transformClassFile(File classFile) {
        boolean didProcessClass;
        block11: {
            didProcessClass = false;
            try {
                if (FileUtils.isArchive(classFile)) {
                    didProcessClass = this.transformAndExplodeArchive(classFile);
                    break block11;
                }
                if (classFile.isDirectory()) {
                    didProcessClass = this.transformDirectory(classFile);
                    break block11;
                }
                String classpath = classFile.getAbsolutePath();
                if (classpath.startsWith(this.inputFile.getAbsolutePath())) {
                    classpath = classpath.substring(this.inputFile.getAbsolutePath().length() + 1);
                }
                File transformedClassFile = new File(this.outputFile, classpath);
                FileInputStream classBytesInputStream = null;
                ByteArrayInputStream classBytesOutputStream = null;
                try {
                    classBytesInputStream = new FileInputStream(classFile);
                    if (FileUtils.isClass(classFile)) {
                        classBytesOutputStream = this.transformClassByteStream(classpath, classBytesInputStream);
                        didProcessClass = this.writeClassFile(classBytesOutputStream, transformedClassFile);
                    } else {
                        this.log.debug("[ClassTransformer] Class ignored: " + classFile.getName());
                        didProcessClass = this.writeClassFile(classBytesInputStream, transformedClassFile);
                    }
                    this.closeQuietly(classBytesInputStream);
                    this.closeQuietly(classBytesOutputStream);
                }
                catch (Exception e) {
                    try {
                        this.log.error("[ClassTransformer] transformClassFile: " + e);
                        didProcessClass = this.writeClassFile(classBytesInputStream, transformedClassFile);
                        this.closeQuietly(classBytesInputStream);
                        this.closeQuietly(classBytesOutputStream);
                    }
                    catch (Throwable throwable) {
                        this.closeQuietly(classBytesInputStream);
                        this.closeQuietly(classBytesOutputStream);
                        throw throwable;
                    }
                }
            }
            catch (Exception e) {
                this.log.error("[ClassTransformer] transformClassFile: " + e);
            }
        }
        return didProcessClass;
    }

    public boolean transformDirectory(File directory) {
        boolean didProcessDirectory = false;
        if (directory.isDirectory()) {
            for (File f : Objects.requireNonNull(directory.listFiles())) {
                didProcessDirectory |= this.transformClassFile(f);
            }
        }
        return didProcessDirectory;
    }

    public boolean transformAndExplodeArchive(File archiveFile) throws IOException {
        return this.transformArchive(archiveFile, true);
    }

    public boolean transformArchive(File archiveFile) throws IOException {
        return this.transformArchive(archiveFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean transformArchive(File archiveFile, boolean explodeJar) throws IOException {
        JarFile jarFile;
        JarOutputStream jarOutputStream;
        JarInputStream jarInputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        FileInputStream archiveFileInputStream;
        boolean didProcessArchive;
        block26: {
            didProcessArchive = false;
            if (FileUtils.isSupportJar(archiveFile)) {
                this.log.debug("[ClassTransformer] Skipping support jar [" + archiveFile.getPath() + "]");
                return false;
            }
            this.log.debug("[ClassTransformer] Transforming archive[" + archiveFile.getCanonicalPath() + "]");
            archiveFileInputStream = null;
            byteArrayOutputStream = null;
            jarInputStream = null;
            jarOutputStream = null;
            jarFile = null;
            jarFile = new JarFile(archiveFile);
            byteArrayOutputStream = new ByteArrayOutputStream();
            archiveFileInputStream = new FileInputStream(archiveFile);
            jarInputStream = new JarInputStream(archiveFileInputStream);
            jarOutputStream = new JarOutputStream(byteArrayOutputStream);
            boolean doTransform = this.verifyAndWriteManifest(jarFile, jarOutputStream);
            if (doTransform) break block26;
            this.log.info("[ClassTransformer] Skipping instrumentation of signed jar [" + archiveFile.getPath() + "]");
            boolean bl = Streams.copy(new FileInputStream(archiveFile), new FileOutputStream(this.outputFile)) > 0;
            this.closeQuietly(jarFile);
            this.closeQuietly(archiveFileInputStream);
            this.closeQuietly(byteArrayOutputStream);
            this.closeQuietly(jarInputStream);
            this.closeQuietly(jarOutputStream);
            return bl;
        }
        try {
            JarEntry entry = jarInputStream.getNextJarEntry();
            while (entry != null) {
                String jarEntryPath = entry.getName();
                if (!entry.isDirectory()) {
                    JarEntry jarEntry = new JarEntry(jarEntryPath);
                    File archiveClassFile = new File(this.outputFile, jarEntryPath);
                    InputStream classBytesInputStream = null;
                    ByteArrayInputStream classBytesOutputStream = null;
                    try {
                        jarEntry.setTime(entry.getTime());
                        jarOutputStream.putNextEntry(jarEntry);
                        classBytesInputStream = jarFile.getInputStream(entry);
                        classBytesOutputStream = this.transformClassByteStream(archiveClassFile.getPath(), classBytesInputStream);
                        if (explodeJar) {
                            didProcessArchive |= this.writeClassFile(classBytesOutputStream, archiveClassFile);
                        } else {
                            this.writeClassStream(classBytesOutputStream, jarOutputStream);
                            didProcessArchive = true;
                        }
                        jarOutputStream.flush();
                        jarOutputStream.closeEntry();
                        this.closeQuietly(classBytesInputStream);
                        this.closeQuietly(classBytesOutputStream);
                    }
                    catch (Exception e) {
                        try {
                            this.log.warn("[ClassTransformer] transformArchive: " + e);
                            if (explodeJar) {
                                didProcessArchive |= this.writeClassFile(classBytesInputStream, archiveClassFile);
                            } else {
                                this.writeClassStream(classBytesInputStream, jarOutputStream);
                                didProcessArchive = true;
                            }
                            this.closeQuietly(classBytesInputStream);
                            this.closeQuietly(classBytesOutputStream);
                        }
                        catch (Throwable throwable) {
                            this.closeQuietly(classBytesInputStream);
                            this.closeQuietly(classBytesOutputStream);
                            throw throwable;
                        }
                    }
                }
                entry = jarInputStream.getNextJarEntry();
            }
            if (didProcessArchive) {
                File rewrittenJar = new File(this.outputFile.getAbsolutePath());
                if (archiveFile.getAbsolutePath() != rewrittenJar.getAbsolutePath()) {
                    this.log.debug("[ClassTransformer] Rewriting archive to [" + rewrittenJar.getAbsolutePath() + "]");
                    this.closeQuietly(jarOutputStream);
                    try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.writeClassFile(byteArrayInputStream, rewrittenJar);
                    }
                    catch (Exception e) {
                        this.log.error("[ClassTransformer] transformArchive: " + e);
                    }
                } else {
                    this.log.error("[ClassTransformer] Refusing to overwrite archive [" + rewrittenJar.getAbsolutePath() + "]");
                }
            }
            this.closeQuietly(jarFile);
            this.closeQuietly(archiveFileInputStream);
            this.closeQuietly(byteArrayOutputStream);
            this.closeQuietly(jarInputStream);
            this.closeQuietly(jarOutputStream);
        }
        catch (Exception e) {
            try {
                this.log.warn("[ClassTransformer] transformArchive: Original library file is outputted as we encountered an exception");
                this.log.warn("[ClassTransformer] transformArchive: " + e);
                boolean bl = Streams.copy(new FileInputStream(archiveFile), new FileOutputStream(this.outputFile)) > 0;
                this.closeQuietly(jarFile);
                this.closeQuietly(archiveFileInputStream);
                this.closeQuietly(byteArrayOutputStream);
                this.closeQuietly(jarInputStream);
                this.closeQuietly(jarOutputStream);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeQuietly(jarFile);
                this.closeQuietly(archiveFileInputStream);
                this.closeQuietly(byteArrayOutputStream);
                this.closeQuietly(jarInputStream);
                this.closeQuietly(jarOutputStream);
                throw throwable;
            }
        }
        return didProcessArchive;
    }

    public boolean verifyManifest(JarFile jarFile) throws IOException {
        Manifest realManifest = jarFile.getManifest();
        if (realManifest != null) {
            Map<String, Attributes> entries = realManifest.getEntries();
            for (String entryKey : entries.keySet()) {
                Attributes attrs = realManifest.getAttributes(entryKey);
                for (Object attr : attrs.keySet()) {
                    String attrKeyName = attr.toString();
                    if (!attrKeyName.matches(MANIFEST_SHA_DIGEST_REGEX)) continue;
                    return false;
                }
            }
            realManifest.getMainAttributes().put(new Attributes.Name(MANIFEST_TRANSFORMED_BY_KEY), "New Relic Android Agent");
        }
        return true;
    }

    public boolean verifyAndWriteManifest(JarFile jarFile, JarOutputStream jarOutputStream) throws IOException {
        if (!this.verifyManifest(jarFile)) {
            return false;
        }
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
        }
        JarEntry manifestJarEntry = new JarEntry("META-INF/MANIFEST.MF");
        manifest.getMainAttributes().put(new Attributes.Name(MANIFEST_TRANSFORMED_BY_KEY), "New Relic Android Agent");
        jarOutputStream.putNextEntry(manifestJarEntry);
        manifest.write(jarOutputStream);
        jarOutputStream.flush();
        jarOutputStream.closeEntry();
        return true;
    }

    public ClassTransformer asIdentityTransform(boolean identityTransform) {
        this.identityTransform = identityTransform;
        return this;
    }

    public ClassTransformer asMutableTransform(boolean mutableTransform) {
        return this.asIdentityTransform(!mutableTransform);
    }

    public ClassTransformer withWriteMode(WriteMode writeMode) {
        this.writeMode = writeMode;
        return this;
    }

    public ClassTransformer usingVariant(String variantName) {
        if (variantName != null && !variantName.isEmpty()) {
            this.invocationDispatcher.getInstrumentationContext().setVariantName(variantName);
        }
        return this;
    }

    protected boolean writeClassStream(InputStream inStream, OutputStream outStrm) throws IOException {
        if ((this.writeMode == WriteMode.always || this.writeMode == WriteMode.modified && this.classData != null && this.classData.isModified()) && inStream != null) {
            return 0 < Streams.copy(inStream, outStrm);
        }
        return false;
    }

    protected boolean writeClassFile(InputStream inStream, File className) throws IOException {
        boolean writeResult = false;
        if (this.writeMode == WriteMode.always || this.writeMode == WriteMode.modified && this.classData != null && this.classData.isModified()) {
            if (inStream != null && className != null) {
                className.getParentFile().mkdirs();
                try (FileOutputStream modifiedClassBytesStream = new FileOutputStream(className);){
                    writeResult = this.writeClassStream(inStream, modifiedClassBytesStream);
                    this.closeQuietly(modifiedClassBytesStream);
                }
                catch (FileNotFoundException e) {
                    this.log.debug("writeClassFile: " + e);
                }
                catch (IOException e) {
                    this.log.error("writeClassFile: " + e);
                }
            } else {
                this.log.error("writeClassFile: input stream or class name is missing!");
            }
        }
        return writeResult;
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.log.warn("[ClassTransformer] closeQuietly: " + e);
            }
        }
    }

    public static enum WriteMode {
        modified,
        always;

    }
}

