/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.thrift.internal.reporters.protocols;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TEndpointTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftUdpTransport
extends TEndpointTransport
implements Closeable {
    public static final int MAX_PACKET_SIZE = 65000;
    public int receiveOffSet = -1;
    public int receiveLength = 0;
    public final DatagramSocket socket = new DatagramSocket(null);
    public byte[] receiveBuf;
    public ByteBuffer writeBuffer;

    public static ThriftUdpTransport newThriftUdpClient(String host, int port) throws TTransportException {
        ThriftUdpTransport t2;
        try {
            t2 = new ThriftUdpTransport();
            t2.socket.connect(new InetSocketAddress(host, port));
        }
        catch (SocketException e) {
            throw new RuntimeException("TUDPTransport cannot connect: ", e);
        }
        return t2;
    }

    public static ThriftUdpTransport newThriftUdpServer(String host, int port) throws SocketException, TTransportException, UnknownHostException {
        ThriftUdpTransport t2 = new ThriftUdpTransport();
        t2.socket.bind(new InetSocketAddress(host, port));
        return t2;
    }

    private ThriftUdpTransport() throws TTransportException, SocketException {
        super(new TConfiguration());
    }

    int getPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public void open() throws TTransportException {
    }

    @Override
    public void close() {
        this.socket.close();
    }

    @Override
    public int getBytesRemainingInBuffer() {
        return 0;
    }

    @Override
    public int read(byte[] bytes, int offset, int len) throws TTransportException {
        int curDataSize;
        if (!this.isOpen()) {
            throw new TTransportException(1);
        }
        if (this.receiveOffSet == -1) {
            this.receiveBuf = new byte[65000];
            DatagramPacket dg = new DatagramPacket(this.receiveBuf, 65000);
            try {
                this.socket.receive(dg);
            }
            catch (IOException e) {
                throw new TTransportException(0, "ERROR from underlying socket", e);
            }
            this.receiveOffSet = 0;
            this.receiveLength = dg.getLength();
        }
        if ((curDataSize = this.receiveLength - this.receiveOffSet) <= len) {
            System.arraycopy(this.receiveBuf, this.receiveOffSet, bytes, offset, curDataSize);
            this.receiveOffSet = -1;
            return curDataSize;
        }
        System.arraycopy(this.receiveBuf, this.receiveOffSet, bytes, offset, len);
        this.receiveOffSet += len;
        return len;
    }

    @Override
    public void write(byte[] bytes, int offset, int len) throws TTransportException {
        if (!this.isOpen()) {
            throw new TTransportException(1);
        }
        if (this.writeBuffer == null) {
            this.writeBuffer = ByteBuffer.allocate(65000);
        }
        if (this.writeBuffer.position() + len > 65000) {
            throw new TTransportException(0, "Message size too large: " + len + " > " + 65000);
        }
        this.writeBuffer.put(bytes, offset, len);
    }

    @Override
    public void flush() throws TTransportException {
        if (this.writeBuffer != null) {
            byte[] bytes = new byte[65000];
            int len = this.writeBuffer.position();
            this.writeBuffer.flip();
            this.writeBuffer.get(bytes, 0, len);
            try {
                this.socket.send(new DatagramPacket(bytes, len));
            }
            catch (IOException e) {
                throw new TTransportException(0, "Cannot flush closed transport", e);
            }
            finally {
                this.writeBuffer = null;
            }
        }
    }

    public String toString() {
        return "ThriftUdpTransport(receiveOffSet=" + this.receiveOffSet + ", receiveLength=" + this.receiveLength + ")";
    }
}

