/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.influxdb.data;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;

public class InfluxDbPoint {
    private String measurement;
    private Map<String, String> tags = Collections.emptyMap();
    private long timestamp;
    private String value;

    public InfluxDbPoint(String measurement, long timestamp, String value) {
        this.measurement = measurement;
        this.timestamp = timestamp;
        this.value = value;
    }

    public InfluxDbPoint(String measurement, Map<String, String> tags, long timestamp, String value) {
        this.measurement = measurement;
        this.timestamp = timestamp;
        this.value = value;
        this.tags = tags;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(String measurement) {
        this.measurement = measurement;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        String t2 = InfluxDbPoint.map2String(this.tags);
        return this.measurement + (String)(t2.length() > 0 ? "," + t2 : "") + " value=" + this.value + " " + this.timestamp;
    }

    public static String map2String(Map<String, String> tags) {
        if (tags != null && !tags.isEmpty()) {
            StringJoiner joined = new StringJoiner(",");
            Iterator<Map.Entry<String, String>> iterator2 = tags.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> o;
                Map.Entry<String, String> pair = o = iterator2.next();
                joined.add(pair.getKey() + "=" + pair.getValue());
            }
            return joined.toString();
        }
        return "";
    }
}

