/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.traceability;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.traceability.TraceabilityConfig;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TraceabilityHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(TraceabilityHandler.class);
    private static final String TID = "tId";
    public static TraceabilityConfig config;
    private volatile HttpHandler next;

    public TraceabilityHandler() {
        config = TraceabilityConfig.load();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String tid;
        if (logger.isDebugEnabled()) {
            logger.trace("TraceabilityHandler.handleRequest starts.");
        }
        if ((tid = exchange.getRequestHeaders().getFirst(HttpStringConstants.TRACEABILITY_ID)) != null) {
            exchange.getResponseHeaders().put(HttpStringConstants.TRACEABILITY_ID, tid);
            this.addHandlerMDCContext(exchange, TID, tid);
            MDC.put(TID, tid);
        } else {
            MDC.remove(TID);
        }
        if (logger.isDebugEnabled()) {
            logger.trace("TraceabilityHandler.handleRequest ends.");
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule("traceability", TraceabilityHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("handler"), null);
    }

    @Override
    public void reload() {
        config.reload();
        ModuleRegistry.registerModule("traceability", TraceabilityHandler.class.getName(), config.getMappedConfig(), null);
        if (logger.isInfoEnabled()) {
            logger.info("TraceabilityHandler is reloaded.");
        }
    }
}

