/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.portal.registry;

import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.portal.registry.PortalRegistryConfig;
import com.networknt.portal.registry.PortalRegistryConstants;
import com.networknt.portal.registry.PortalRegistryHeartbeatManager;
import com.networknt.portal.registry.PortalRegistryService;
import com.networknt.portal.registry.PortalRegistryUtils;
import com.networknt.portal.registry.client.PortalRegistryClient;
import com.networknt.portal.registry.client.PortalRegistryWebSocketClient;
import com.networknt.registry.NotifyListener;
import com.networknt.registry.URL;
import com.networknt.registry.URLParamType;
import com.networknt.registry.support.AbstractRegistry;
import com.networknt.utility.ConcurrentHashSet;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalRegistry
extends AbstractRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PortalRegistry.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";
    private static final PortalRegistryConfig config = (PortalRegistryConfig)Config.getInstance().getJsonObjectConfig("portal-registry", PortalRegistryConfig.class);
    PortalRegistryWebSocketClient webSocketClient = null;
    private PortalRegistryClient client;
    private PortalRegistryHeartbeatManager heartbeatManager;
    private int lookupInterval;
    private static Set<URL> subscribedSet = new ConcurrentHashSet<URL>();
    private ConcurrentHashMap<String, List<URL>> serviceCache = new ConcurrentHashMap();

    public PortalRegistry(URL url, PortalRegistryClient client) {
        super(url);
        this.client = client;
        if (this.getPortalRegistryConfig().ttlCheck) {
            this.heartbeatManager = new PortalRegistryHeartbeatManager(client, this.getPortalToken());
            this.heartbeatManager.start();
        }
        this.lookupInterval = this.getUrl().getIntParameter(URLParamType.registrySessionTimeout.getName(), PortalRegistryConstants.DEFAULT_LOOKUP_INTERVAL);
        logger.info("PortalRegistry init finish.");
        ModuleRegistry.registerModule("portal-registry", PortalRegistry.class.getName(), Config.getInstance().getJsonMapConfigNoCache("portal-registry"), null);
    }

    @Override
    protected void doRegister(URL url) {
        PortalRegistryService service = PortalRegistryUtils.buildService(url);
        this.client.registerService(service, this.getPortalToken());
        if (this.getPortalRegistryConfig().ttlCheck) {
            this.heartbeatManager.addHeartbeatService(service);
        }
    }

    @Override
    protected void doUnregister(URL url) {
        PortalRegistryService service = PortalRegistryUtils.buildService(url);
        this.client.unregisterService(service, this.getPortalToken());
        if (this.getPortalRegistryConfig().ttlCheck) {
            this.heartbeatManager.removeHeartbeatService(service);
        }
    }

    @Override
    protected void doAvailable(URL url) {
        if (url == null) {
            if (this.getPortalRegistryConfig().ttlCheck) {
                this.heartbeatManager.setHeartbeatOpen(true);
            }
        } else {
            throw new UnsupportedOperationException("Portal registry not support available by urls yet");
        }
    }

    @Override
    protected void doUnavailable(URL url) {
        if (url == null) {
            if (this.getPortalRegistryConfig().ttlCheck) {
                this.heartbeatManager.setHeartbeatOpen(false);
            }
        } else {
            throw new UnsupportedOperationException("Portal registry not support unavailable by urls yet");
        }
    }

    @Override
    protected void doSubscribe(URL url, NotifyListener listener) {
        if (logger.isInfoEnabled()) {
            logger.info("PortalRegistry subscribe url: " + url.toSimpleString());
        }
        if (!subscribedSet.contains(url)) {
            try {
                String u = "wss" + config.getPortalUrl().substring(config.getPortalUrl().indexOf("://"));
                if (this.webSocketClient == null) {
                    this.webSocketClient = new PortalRegistryWebSocketClient(URI.create(u + "/ws")){

                        @Override
                        public void onOpen() {
                            System.out.println("open");
                        }

                        @Override
                        public void onMessage(String msg) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("WebSocket message: " + msg);
                            }
                            PortalRegistry.this.updateCacheFromMessage(msg);
                        }

                        @Override
                        public void onClose(int code, String reason) {
                            System.out.println("close (code: " + code + ", reason: " + reason + ")");
                        }

                        @Override
                        public void onError(Exception e) {
                            System.out.println("err: " + e.getMessage());
                            System.out.println("Client isOpen?: " + this.isOpen());
                        }
                    };
                }
            }
            catch (Exception e) {
                logger.error("Exception:", e);
            }
            this.webSocketClient.send(url.toFullStr());
        }
        subscribedSet.add(url);
    }

    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        if (logger.isInfoEnabled()) {
            logger.info("PortalRegistry unsubscribe url: " + url.toSimpleString());
        }
        try {
            if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
                this.webSocketClient.close();
            }
        }
        catch (Exception e) {
            logger.error("Exception:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<URL> doDiscover(URL url) {
        List<URL> urls2;
        String serviceId = url.getPath();
        String tag = url.getParameter("environment");
        String key = tag == null ? serviceId : serviceId + "|" + tag;
        String protocol = url.getProtocol();
        if (logger.isTraceEnabled()) {
            logger.trace("discover protocol = " + protocol + " serviceId = " + serviceId + " tag = " + tag);
        }
        if ((urls2 = this.serviceCache.get(key)) == null || urls2.isEmpty()) {
            String string = key.intern();
            synchronized (string) {
                urls2 = this.serviceCache.get(key);
                if (urls2 == null || urls2.isEmpty()) {
                    ConcurrentHashMap<String, List<URL>> serviceUrls = this.lookupServiceUpdate(protocol, serviceId, tag);
                    this.updateServiceCache(key, serviceUrls, false);
                    urls2 = this.serviceCache.get(key);
                }
            }
        }
        return urls2;
    }

    private ConcurrentHashMap<String, List<URL>> lookupServiceUpdate(String protocol, String serviceId, String tag) {
        if (logger.isTraceEnabled()) {
            logger.trace("protocol = " + protocol + " serviceId = " + serviceId + " tag = " + tag);
        }
        List<Map<String, Object>> services = this.lookupService(serviceId, tag);
        return this.convertLisMap2UR(serviceId, tag, protocol, services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheFromMessage(String message) {
        Map<String, Object> map = JsonMapper.string2Map(message);
        Iterator<Map.Entry<String, Object>> iterator2 = map.entrySet().iterator();
        Map.Entry<String, Object> entry = iterator2.next();
        String key = entry.getKey();
        String serviceId = null;
        String tag = null;
        if (key.indexOf("|") > 0) {
            String[] parts = StringUtils.split(key, "|");
            serviceId = parts[0];
            tag = parts[1];
        } else {
            serviceId = key;
        }
        List nodes = (List)entry.getValue();
        ConcurrentHashMap<String, List<URL>> serviceUrls = this.convertLisMap2UR(serviceId, tag, null, nodes);
        String string = key.intern();
        synchronized (string) {
            this.updateServiceCache(key, serviceUrls, false);
        }
    }

    private ConcurrentHashMap<String, List<URL>> convertLisMap2UR(String serviceId, String tag, String protocol, List<Map<String, Object>> services) {
        String key = tag == null ? serviceId : serviceId + "|" + tag;
        ConcurrentHashMap<String, List<URL>> serviceUrls = new ConcurrentHashMap<String, List<URL>>();
        if (services != null && !services.isEmpty()) {
            for (Map<String, Object> service : services) {
                try {
                    URL url = PortalRegistryUtils.buildUrl(serviceId, tag, service);
                    if (protocol != null && !url.getProtocol().equals(protocol)) continue;
                    List<URL> urlList = serviceUrls.get(key);
                    if (urlList == null) {
                        urlList = new ArrayList<URL>();
                        serviceUrls.put(key, urlList);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("lookupServiceUpdate url = " + url);
                    }
                    urlList.add(url);
                }
                catch (Exception e) {
                    logger.error("convert portal registry service to url fail! service:" + service, e);
                }
            }
            return serviceUrls;
        }
        serviceUrls.put(key, new ArrayList());
        logger.info("no response for service: {}, set urls to empty list", (Object)key);
        return serviceUrls;
    }

    private List<Map<String, Object>> lookupService(String serviceId, String tag) {
        return this.client.lookupHealthService(serviceId, tag, this.getPortalToken());
    }

    private void updateServiceCache(String key, ConcurrentHashMap<String, List<URL>> serviceUrls, boolean needNotify) {
        if (serviceUrls != null && !serviceUrls.isEmpty()) {
            List<URL> cachedUrls = this.serviceCache.get(key);
            List<URL> newUrls = serviceUrls.get(key);
            if (logger.isTraceEnabled()) {
                logger.trace("serviceUrls = " + JsonMapper.toJson(serviceUrls));
            }
            boolean change = true;
            if (PortalRegistryUtils.isSame(newUrls, cachedUrls)) {
                change = false;
            } else {
                this.serviceCache.put(key, newUrls);
            }
        }
    }

    private PortalRegistryConfig getPortalRegistryConfig() {
        return (PortalRegistryConfig)Config.getInstance().getJsonObjectConfig("portal-registry", PortalRegistryConfig.class);
    }

    private String getPortalToken() {
        String token = config.getPortalToken();
        if (token == null) {
            return null;
        }
        if (token.toUpperCase().startsWith("BEARER ")) {
            return "Bearer " + token.substring(7);
        }
        return "Bearer " + token;
    }
}

