/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.openapi.InjectableSpecValidator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInjectableSpecValidator
implements InjectableSpecValidator {
    public static String PATHS = "paths";
    Logger logger = LoggerFactory.getLogger(DefaultInjectableSpecValidator.class);

    @Override
    public boolean isValid(Map<String, Object> openapi, Map<String, Object> inject) {
        if (inject == null) {
            return true;
        }
        if (inject.get(PATHS) instanceof Map && openapi.get(PATHS) instanceof Map) {
            for (Map.Entry injectPath : ((Map)inject.get(PATHS)).entrySet()) {
                if (!((Map)openapi.get(PATHS)).containsKey(injectPath.getKey())) continue;
                Map openapiPath = (Map)((Map)openapi.get(PATHS)).get(injectPath.getKey());
                Set openapiMethods = openapiPath.keySet();
                Set injectMethods = ((Map)injectPath.getValue()).keySet();
                for (String injectMethod : injectMethods) {
                    if (!openapiMethods.contains(injectMethod)) continue;
                    this.logger.error("you are trying to overwritten an existing path: {} with method: {}", injectPath.getKey(), (Object)injectMethod);
                    return false;
                }
            }
        }
        return true;
    }
}

