/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.service.handler;

import com.networknt.body.BodyHandler;
import com.networknt.config.Config;
import com.networknt.oauth.cache.AuditInfoHandler;
import com.networknt.oauth.cache.model.AuditInfo;
import com.networknt.oauth.cache.model.Oauth2Service;
import com.networknt.oauth.service.handler.OauthServiceConfig;
import io.undertow.server.HttpServerExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceAuditHandler
extends AuditInfoHandler {
    static final Logger logger = LoggerFactory.getLogger(ServiceAuditHandler.class);
    private static final String CONFIG = "oauth_service";
    private static final OauthServiceConfig oauth_config = (OauthServiceConfig)Config.getInstance().getJsonObjectConfig("oauth_service", OauthServiceConfig.class);

    protected void processAudit(HttpServerExchange exchange) throws Exception {
        if (oauth_config.isEnableAudit()) {
            AuditInfo auditInfo = new AuditInfo();
            auditInfo.setServiceId(Oauth2Service.SERVICE);
            auditInfo.setEndpoint(exchange.getHostName() + exchange.getRelativePath());
            auditInfo.setRequestHeader(exchange.getRequestHeaders().toString());
            auditInfo.setRequestBody(Config.getInstance().getMapper().writeValueAsString(exchange.getAttachment(BodyHandler.REQUEST_BODY)));
            auditInfo.setResponseCode(exchange.getStatusCode());
            auditInfo.setResponseHeader(exchange.getResponseHeaders().toString());
            auditInfo.setResponseBody(Config.getInstance().getMapper().writeValueAsString(exchange.getResponseCookies()));
            this.saveAudit(auditInfo);
        }
    }
}

