/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.service.handler;

import com.hazelcast.map.IMap;
import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.cache.model.Service;
import com.networknt.oauth.service.handler.ServiceAuditHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2ServiceServiceIdGetHandler
extends ServiceAuditHandler
implements LightHttpHandler {
    static Logger logger = LoggerFactory.getLogger(Oauth2ServiceServiceIdGetHandler.class);
    static final String SERVICE_NOT_FOUND = "ERR12015";

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String serviceId = exchange.getQueryParameters().get("serviceId").getFirst();
        IMap services = CacheStartupHookProvider.hz.getMap("services");
        Service service = (Service)services.get(serviceId);
        if (service == null) {
            this.setExchangeStatus(exchange, SERVICE_NOT_FOUND, serviceId);
            this.processAudit(exchange);
            return;
        }
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "application/json");
        exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(service));
        this.processAudit(exchange);
    }
}

