/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.service.handler;

import com.hazelcast.map.IMap;
import com.networknt.body.BodyHandler;
import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.cache.model.ServiceEndpoint;
import com.networknt.oauth.service.handler.ServiceAuditHandler;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2ServiceServiceIdEndpointPostHandler
extends ServiceAuditHandler
implements LightHttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(Oauth2ServiceServiceIdEndpointPostHandler.class);
    static final String SERVICE_NOT_FOUND = "ERR12015";

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        IMap services;
        List body = (List)exchange.getAttachment(BodyHandler.REQUEST_BODY);
        String serviceId = exchange.getQueryParameters().get("serviceId").getFirst();
        if (logger.isDebugEnabled()) {
            logger.debug("post serviceEndpoints for serviceId " + serviceId);
        }
        if ((services = CacheStartupHookProvider.hz.getMap("services")).get(serviceId) == null) {
            this.setExchangeStatus(exchange, SERVICE_NOT_FOUND, serviceId);
            this.processAudit(exchange);
            return;
        }
        IMap serviceEndpoints = CacheStartupHookProvider.hz.getMap("serviceEndpoints");
        ArrayList<ServiceEndpoint> list = new ArrayList<ServiceEndpoint>();
        for (Map m4 : body) {
            list.add(Config.getInstance().getMapper().convertValue((Object)m4, ServiceEndpoint.class));
        }
        serviceEndpoints.set(serviceId, list);
        this.processAudit(exchange);
    }
}

